
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate data for energy domain
months = np.arange(12)
solar_energy = np.array(
    [80, 120, 160, 200] + sorted(list(np.random.randint(50, 250, 8)))
)
wind_energy = np.array(
    [90, 130, 140, 210] + sorted(list(np.random.randint(60, 240, 8)))
)
hydropower_energy = [sorted(np.random.randint(20, 120, 8), reverse=True) for i in range(2)]
adjusted_months = np.array(months, dtype=float)
adjusted_months[3] += 0.5
adjusted_months[4:] += 4

title = "Solar Energy Production"
xlabel = "Months"
ylabel = "Energy Produced (GWh)"
ylim = [0, 260]
axhline = 250

title2 = "Wind Energy Production"
xlabel2 = "Months"
ylabel2 = "Energy Produced (GWh)"
ylim2 = [0, 260]
axhline2 = 250
xticks = adjusted_months[4:]
xtickslabel = np.arange(1, 9)

# Colors for the bars
solar_colors = [plt.cm.YlOrRd(i) for i in np.linspace(0.8, 0.5, 8)]
wind_colors = [plt.cm.GnBu(i) for i in np.linspace(0.3, 0.7, 8)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 4))

# Subplot 1: Solar Energy Production
plt.subplot(1, 2, 1)
plt.bar(adjusted_months[:4], solar_energy[:4], color=["#FFA07A", "#FFD700", "#FF4500", "orange"])
plt.bar(adjusted_months[4:], solar_energy[4:], color=solar_colors)
plt.bar(adjusted_months[4:], hydropower_energy[0], width=0.5, color=wind_colors)
plt.title(title, y=-0.3)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline, linestyle="dotted", color="black")
plt.legend(["Hydropower", "Solar"], loc="upper right")

# Subplot 2: Wind Energy Production
plt.subplot(1, 2, 2)
plt.bar(adjusted_months[:4], wind_energy[:4], color=["#7FFFD4", "#00BFFF", "#1E90FF", "blue"])
plt.bar(adjusted_months[4:], wind_energy[4:], color=wind_colors)
plt.bar(adjusted_months[4:], hydropower_energy[1], width=0.5, color=solar_colors)
plt.title(title2, y=-0.3)
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.ylim(ylim2)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline2, linestyle="dotted", color="black")
plt.legend(["Hydropower", "Wind"], loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_33.pdf", bbox_inches="tight")
