
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import Normalize

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample business data
alpha = np.linspace(0, 10, 15)  # Number of regions
beta = np.linspace(0, 12, 15)   # Months
Alpha, Beta = np.meshgrid(alpha, beta)
sales_performance = (Alpha.max() - Alpha) / Alpha.max() + (Beta.max() - Beta) / Beta.max()
customer_satisfaction = 0.5 - sales_performance * (0.5 + 0.5) / 2

# Reverse the order for better readability (optional)
new_customer_satisfaction = []
for line in customer_satisfaction:
    new_customer_satisfaction.append(line[::-1])

dashed_line = alpha * 0.7  # Adjusted function for dashed line (e.g. sales target line)
xlabel = "Regions"
ylabel = "Months"
label = "Customer Satisfaction"
title = "Sales Performance and Customer Satisfaction"
subtitle = "Across different regions and months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Create a heatmap
norm = Normalize(vmin=np.min(customer_satisfaction), vmax=np.max(customer_satisfaction))
cmap = plt.get_cmap("viridis")
heatmap = ax.imshow(
    new_customer_satisfaction, aspect="auto", cmap=cmap, norm=norm, extent=[0, 10, 0, 12], origin="lower"
)

# Add a colorbar
cbar = plt.colorbar(heatmap, ax=ax, label=label)
cbar.ax.tick_params(labelsize=10)

# Add a dashed line (e.g., sales target)
ax.plot(alpha, dashed_line, "r--", linewidth=2)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(f"{title}\n{subtitle}", fontsize=16, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("HR_42.pdf", bbox_inches="tight")
