
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import Normalize

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data
alpha = np.linspace(0, 2, 15)  # GDP Growth Rate (%)
beta = np.linspace(0, 0.5, 15)  # Inflation Rate (%)
Alpha, Beta = np.meshgrid(alpha, beta)
gradient = (Alpha.max() - Alpha) / Alpha.max() + (Beta.max() - Beta) / Beta.max()
Z = 0.0015 - gradient * (0.0015 + 0.0015) / 2
new_Z = [line[::-1] for line in Z]
dashed_line = alpha * 0.25  # Adjusted function for dashed line

# Text labels
xlabel = "GDP Growth Rate (%)"
ylabel = "Inflation Rate (%)"
colorbar_label = "Economic Performance Indicator"
title = "Economic Performance Heatmap"
dashed_line_label = "Trend Line"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific dimensions
fig, ax = plt.subplots(figsize=(8, 7))

# Create a heatmap
norm = Normalize(vmin=np.min(Z), vmax=np.max(Z))
cmap = plt.get_cmap("RdYlGn")
heatmap = ax.imshow(
    new_Z, aspect="auto", cmap=cmap, norm=norm, extent=[0, 2, 0, 0.5], origin="lower"
)

# Add a colorbar
cbar = plt.colorbar(heatmap, ax=ax, label=colorbar_label)
cbar.ax.tick_params(labelsize=8)

# Add a dashed line (approximation)
ax.plot(alpha, dashed_line, "b-", label=dashed_line_label)

# Set labels, title, and legend
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)
ax.legend(loc='upper left')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("HR_43.pdf", bbox_inches="tight")
