
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generating data for philosophical schools of thought over time
time = np.linspace(0, 100, 100)
stoicism_influence = 0.1 - 0.001 * (time - 50) ** 2
existentialism_influence = 0.075 - 0.0008 * (time - 50) ** 2
nihilism_influence = 0.05 - 0.0006 * (time - 50) ** 2
absurdism_influence = 0.025 - 0.0004 * (time - 50) ** 2
pragmatism_influence = 0.01 - 0.0002 * (time - 50) ** 2

# Generating data for philosophical influence distribution among a population
Stoicism = np.random.rand(2, 17) * 10
Existentialism = np.random.rand(4, 17) * 10
Nihilism = np.random.rand(5, 17) * 10
Absurdism = np.random.rand(4, 17) * 10
Pragmatism = np.random.rand(2, 17) * 10
Stoicism = [sorted(s1, reverse=True) for s1 in Stoicism]
Existentialism = [sorted(e1, reverse=True) for e1 in Existentialism]
Absurdism = [sorted(a1) for a1 in Absurdism]
Pragmatism = [sorted(p1) for p1 in Pragmatism]
xlabel = "Time (T)"
ylabel = "Influence (I)"
title = "Influence of Philosophical Schools of Thought Over Time"
baseline = 0
labels = ["Stoicism", "Existentialism", "Nihilism", "Absurdism", "Pragmatism"]
textheight = 14
xlabel2 = "Philosophical Schools (P)"
ylabel2 = "Population Influence (PI)"
title2 = "Influence Distribution Among Population"
plotlabels = ["Stoicism", "Existentialism", "Nihilism", "Absurdism", "Pragmatism"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
colors = ["#8c564b", "#1f77b4", "#2ca02c", "#d62728", "#9467bd"]
plt.figure(figsize=(10, 5))
# Create the left plot (Influence over time)
plt.subplot(1, 2, 1)
plt.plot(time, stoicism_influence, label=plotlabels[0], color=colors[0], linestyle='-', linewidth=2)
plt.plot(time, existentialism_influence, label=plotlabels[1], color=colors[1], linestyle='--', linewidth=2)
plt.plot(time, nihilism_influence, label=plotlabels[2], color=colors[2], linestyle='-.', linewidth=2)
plt.plot(time, absurdism_influence, label=plotlabels[3], color=colors[3], linestyle=':', linewidth=2)
plt.plot(time, pragmatism_influence, label=plotlabels[4], color=colors[4], linestyle='-', linewidth=1)

plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()
plt.grid(True, linestyle='--', alpha=0.7)

# Create the right plot (Influence distribution among population)
plt.subplot(1, 2, 2)

for index, values in enumerate([Stoicism, Existentialism, Nihilism, Absurdism, Pragmatism]):
    for i in range(len(values)):
        plt.scatter(
            [baseline + i] * len(values[i]),
            range(len(values[i])),
            s=values[i],
            c=colors[index],
        )
    plt.text(baseline + len(values) / 2, textheight, labels[index], ha='center',fontsize=8)
    baseline = baseline + len(values)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

plt.xticks([])
plt.yticks([])
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.title(title2, y=1.05)
plt.gca().set_facecolor('#f7f7f7')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("HR_44.pdf", bbox_inches="tight")
