
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulated data for technology adoption
users = np.linspace(0, 100, 100)
adoption_early = 0.12 - 0.001 * (users - 30) ** 2
adoption_early_majority = 0.1 - 0.0009 * (users - 50) ** 2
adoption_late_majority = 0.08 - 0.0007 * (users - 70) ** 2
adoption_laggards = 0.05 - 0.0005 * (users - 90) ** 2
adoption_non_adopters = 0.02 - 0.0003 * (users - 100) ** 2

E = np.random.rand(2, 17) * 10
EM = np.random.rand(4, 17) * 10
LM = np.random.rand(5, 17) * 10
LA = np.random.rand(4, 17) * 10
NA = np.random.rand(2, 17) * 10
E = [sorted(e1, reverse=True) for e1 in E]
EM = [sorted(em1, reverse=True) for em1 in EM]
LM = [sorted(lm1) for lm1 in LM]
NA = [sorted(na1) for na1 in NA]
xlabel = "Users (U)"
ylabel = "Adoption Rate (f)"
title = "Technology Adoption Distribution"
baseline = 0
labels = ["Early", "Early Majority", "Late Majority", "Laggards", "Non-Adopters"]
textheight = 16.5
xlabel2 = "Items(C)"
ylabel2 = "Users(U)"
title2 = "User Preference Matrix (M)"
plotlabels = ["Early", "Early Majority", "Late Majority", "Laggards", "Non-Adopters"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(10, 5))

colors = ["navy", "dodgerblue", "grey", "limegreen", "crimson"]

# Create the left plot (Technology Adoption Distribution)
plt.subplot(1, 2, 1)
plt.plot(users, adoption_early, label=plotlabels[0], color=colors[0], linestyle='-', linewidth=2)
plt.plot(users, adoption_early_majority, label=plotlabels[1], color=colors[1], linestyle='--', linewidth=2)
plt.plot(users, adoption_late_majority, label=plotlabels[2], color=colors[2], linestyle='-.', linewidth=2)
plt.plot(users, adoption_laggards, label=plotlabels[3], color=colors[3], linestyle=':', linewidth=2)
plt.plot(users, adoption_non_adopters, label=plotlabels[4], color=colors[4], linestyle='-', linewidth=2)

plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Create the right plot (User Preference Matrix (M))
plt.subplot(1, 2, 2)

for index, values in enumerate([E, EM, LM, LA, NA]):
    for i in range(len(values)):
        plt.scatter(
            [baseline + i] * len(values[i]),
            range(len(values[i])),
            s=values[i],
            c=colors[index],
            alpha=0.7,
            edgecolors='w',
            linewidth=0.5
        )
    plt.text(baseline + len(values) / 2, textheight, labels[index], ha='center', fontsize=8, color='black')
    baseline = baseline + len(values)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

plt.xticks([])
plt.yticks([])
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.title(title2, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("HR_46.pdf", bbox_inches="tight")

