
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # New seed for different random data

# Define the parallelogram boundary points
boundary_points = np.array([[0, 0], [3, -1], [2, 2], [-1, 3]])

# Define the data for each subplot
# Simulate investment returns distribution
data1 = np.random.randn(100000, 2) * [0.5, 0.5]  # High variance returns
data2 = np.random.rand(1000, 2) * [2, 2]          # Moderate returns
data3 = np.random.rand(1000, 2) * [2, 1.5] + [1, 0.5]  # Adjusted moderate returns

# New labels and text relevant to financial data
ylabel = [
    "Investment A - Returns",
    "Investment B - Returns",
    "Investment C - Returns",
]
xlabel = "Time Period"
labels = ["Q1", "Q2", "Q3", "Q4"]
xlim = [-1, 4]
ylim = [-2, 3]
legendtitle = "Points count = {}"
supertitle = "Investments Return Analysis Over Different Periods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Define the figure size
fig = plt.figure(figsize=(12, 6))
fig.suptitle(supertitle, fontsize=14)

# Create subplots
for i, data in enumerate([data1, data2, data3], 1):
    ax = fig.add_subplot(1, 3, i)
    # Fill the parallelogram
    ax.fill(boundary_points[:, 0], boundary_points[:, 1], color="lightgreen", alpha=0.5)
    ax.set_xlim(xlim)  # Adjusted x limits to better fit the parallelogram
    ax.set_ylim(ylim)  # Adjusted y limits to better fit the parallelogram
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel[i - 1])
    if i != 1:
        ax.set_yticks([])

    for point, label in zip(boundary_points, labels):
        ax.text(point[0], point[1], label, color="darkblue", fontsize=10, ha='center')

    scatter = ax.scatter(data[:, 0], data[:, 1], color="darkred", s=1, marker='o')
    ax.legend([scatter], [legendtitle.format(len(data))], loc="upper left")
    ax.plot(
        np.append(boundary_points[:, 0], boundary_points[0, 0]),
        np.append(boundary_points[:, 1], boundary_points[0, 1]),
        color="darkgreen", linestyle='--', linewidth=1.5
    )

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust layout to make space for the supertitle
plt.savefig("HR_49.pdf", bbox_inches="tight")
