
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
start_r = 1
end_r = 8
num_points = 2500
ellipse_ratio = 1.5

# Generate theta values
theta = np.linspace(0, 16 * np.pi, num_points)

# Exponential function for r to make the spiral even more compact
r = start_r + (end_r - start_r) * (theta / max(theta)) ** 2.5

# Convert to Cartesian coordinates with scaling for the ellipse
x = r * np.cos(theta) * ellipse_ratio
y = r * np.sin(theta)

label = "Media Design Spiral"
title = "Compact Media Spiral with Elliptical Form"
xlabel = "X-axis (Media Units)"
ylabel = "Y-axis (Media Units)"
legend_label = "Spiral Path"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(10, 10))

# Plot with enhanced styling
plt.plot(x, y, linestyle='--', linewidth=1.5, label=legend_label, color='#FF5733')
plt.plot(x[0], y[0], 'o', markersize=8, color='#900C3F', label='Start Point')

# Set titles and labels
plt.title(title, fontsize=16, fontweight='bold', color='#581845')
plt.xlabel(xlabel, fontsize=12, fontweight='bold', color='#581845')
plt.ylabel(ylabel, fontsize=12, fontweight='bold', color='#581845')

# Axis settings
plt.axis('equal')
plt.gca().set_aspect('equal', adjustable='box')
plt.grid(True, linestyle=':', color='gray', alpha=0.7)

# Set legend
plt.legend(loc='upper right', fontsize=10, frameon=True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_53.pdf", bbox_inches="tight")
