
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
num_points = 1000
t = np.linspace(0, 4*np.pi, num_points)
x = t * np.cos(t)
y = t * np.sin(t)
z = t

# Labels and titles
xlabel = "X Axis"
ylabel = "Y Axis"
zlabel = "Z Axis"
title = "3D Helix with Sunset Gradient"
label_helix = "Helix Path"
annotation_text = "Start of Helix"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 6))
ax = fig.add_subplot(projection='3d')

# Color gradient
colors = plt.cm.plasma(np.linspace(0, 1, num_points))

for i in range(num_points-1):
    ax.plot(x[i:i+2], y[i:i+2], z[i:i+2], color=colors[i], linewidth=2)

# Mark the starting point
ax.scatter(x[0], y[0], z[0], color='black', s=50, label=annotation_text)

# Title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)

# Legend
ax.legend()

# Additional adjustments: Grid, Aspect ratio
ax.grid(True)
ax.set_box_aspect([2, 2, 1])  # Aspect ratio for the 3D plot

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_54.pdf", bbox_inches="tight")

