
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
start_r = 1
end_r = 15  # Increased the end radius for a more dynamic spiral
num_points = 3000  # Increased number of points for smoother curves
ellipse_ratio = 1.1
# Generate theta values
theta = np.linspace(0, 6 * np.pi, num_points)

# Exponential function for r to represent knowledge growth
r = start_r + (end_r - start_r) * (theta / max(theta)) ** 2
# Convert to Cartesian coordinates with scaling for the ellipse
x = r * np.cos(theta) * ellipse_ratio
y = r * np.sin(theta)
label = "Knowledge Growth"
title = "Growth of Knowledge Over Time"
xlabel = "Time"
ylabel = "Knowledge Level"
legendlabels = ["Knowledge Growth"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 10))
plt.plot(x, y, label=legendlabels[0], linestyle='-', color="#1f78b4", linewidth=1.5)  # Blue line for knowledge growth
plt.plot(x[0], y[0], "ro")  # Red marker at the start
plt.title(title, fontsize=16, fontweight='bold')
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.axis("equal")
plt.gca().set_aspect("equal", adjustable="box")
plt.legend()
plt.grid(True, linestyle='--', alpha=0.7)  # Adding grid for better readability
plt.gca().set_facecolor('#f0f0f0')  # Light grey background

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_55.pdf", bbox_inches="tight")
