
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Define the data for the radar chart
labels = np.array(
    [
        "Population",
        "Economy",
        "Military Strength",
        "Education",
        "Culture",
        "Technology",
    ]
)
num_vars = len(labels)

values = np.array(
    [
        [70, 60, 30, 40, 55, 30],  # Ancient Egypt
        [65, 70, 40, 50, 60, 35],  # Ancient Greece
        [80, 75, 50, 60, 70, 50],  # Roman Empire
        [55, 50, 20, 35, 45, 25],  # Mesopotamia
        [60, 65, 45, 55, 65, 40],  # Ancient China
    ]
)

# Compute angle for each axis
angles = [n * 2 * pi / float(num_vars) for n in range(num_vars)]
perangles = 2 * pi / (float(num_vars) * (len(values) + 1))
angles += angles[:1]
xticks = [20, 40, 60, 80]
xtickslabel = ["20", "40", "60", "80"]
x_angles = [n + pi / 9 for n in angles[:-1]]

# Define legends
legend_labels = ["Ancient Egypt", "Ancient Greece", "Roman Empire", "Mesopotamia", "Ancient China"]

# Set the start angle to degrees
offset = 11 * pi / 18

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 8))
ax = plt.subplot(projection="polar")

# Set the direction of the plot to clockwise
ax.set_theta_direction(-1)
ax.set_theta_offset(offset)

# Define colors
colors = ["#c2b280", "#a67131", "#8c6b53", "#5a4a3b", "#3d2d1e"]

# Plot data with bars
for index, value in enumerate(values):
    for _index, _value in enumerate(value):
        theta1 = angles[_index] + perangles * index
        theta2 = angles[_index] + perangles * (index + 1)
        ax.bar(theta1, _value, perangles, color=colors[index])

# Add labels
ax.set_xticks(x_angles)
ax.set_xticklabels(labels, fontdict={"fontsize": 10})
ax.set_yticks(xticks)
ax.set_yticklabels(xtickslabel, color="grey")
ax.tick_params(axis="x", which="major", pad=15)

# Add a grid
ax.grid(alpha=0.3)

# Add custom legend
for i in range(len(legend_labels)):
    ax.bar(
        [0, 0, 0, 0, 0], [0, 0, 0, 0, 0], color=colors[-i - 1], label=legend_labels[i]
    )
ax.legend(loc="upper right", bbox_to_anchor=(0.1, 0.2))

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_65.pdf", bbox_inches="tight")
