
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Placeholder transportation data: traffic congestion across times of the day
time_of_day = np.linspace(5, 24, 10)  # Times from 5 AM to 12 AM
congestion_morning = np.exp(-0.15 * time_of_day) + np.random.normal(0, 0.05, 10)
congestion_afternoon = np.exp(-0.1 * time_of_day) + np.random.normal(0, 0.05, 10)
congestion_evening = np.exp(-0.2 * time_of_day + 0.5) + np.random.normal(0, 0.05, 10)
congestion_night = np.exp(-0.25 * time_of_day + 0.9) + np.random.normal(0, 0.05, 10)

# Create error bands
cong_morning_err = congestion_morning * 0.1
cong_afternoon_err = congestion_afternoon * 0.1
cong_evening_err = congestion_evening * 0.15
cong_night_err = congestion_night * 0.15

xlabel = "Time of Day"
ylabels = [
    "Average Traffic Congestion (Morning & Afternoon)",
    "Average Traffic Congestion (Evening & Night)"
]
xlim = [4, 25]
ylim = [0, 1.2]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified size (width, height)
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Plot data and curves for the left subplot (Morning & Afternoon)
ax1.plot(time_of_day, congestion_morning, "o", color="blue", label="Morning Peak")
ax1.fill_between(time_of_day, congestion_morning - cong_morning_err, congestion_morning + cong_morning_err, color="blue", alpha=0.2)
coeffs = np.polyfit(time_of_day, congestion_morning, 2)
fit_func = np.poly1d(coeffs)
ax1.plot(time_of_day, fit_func(time_of_day), "-", color="darkblue")

ax1.plot(time_of_day, congestion_afternoon, "s", color="green", label="Afternoon Peak")
ax1.fill_between(time_of_day, congestion_afternoon - cong_afternoon_err, congestion_afternoon + cong_afternoon_err, color="green", alpha=0.2)
coeffs = np.polyfit(time_of_day, congestion_afternoon, 2)
fit_func = np.poly1d(coeffs)
ax1.plot(time_of_day, fit_func(time_of_day), "-", color="darkgreen")

ax1.set_xlim(xlim)
ax1.set_ylim(ylim)
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabels[0])
ax1.legend(frameon=True)
ax1.set_title("Morning & Afternoon Traffic Congestion")

# Plot data and curves for the right subplot (Evening & Night)
ax2.plot(time_of_day, congestion_evening, "o", color="orange", label="Evening Peak")
ax2.fill_between(time_of_day, congestion_evening - cong_evening_err, congestion_evening + cong_evening_err, color="orange", alpha=0.2)
coeffs = np.polyfit(time_of_day, congestion_evening, 2)
fit_func = np.poly1d(coeffs)
ax2.plot(time_of_day, fit_func(time_of_day), "-", color="darkorange")

ax2.plot(time_of_day, congestion_night, "s", color="red", label="Night Peak")
ax2.fill_between(time_of_day, congestion_night - cong_night_err, congestion_night + cong_night_err, color="red", alpha=0.2)
coeffs = np.polyfit(time_of_day, congestion_night, 2)
fit_func = np.poly1d(coeffs)
ax2.plot(time_of_day, fit_func(time_of_day), "-", color="darkred")

ax2.set_xlim(xlim)
ax2.set_ylim(ylim)
ax2.set_xlabel(xlabel)
ax2.set_ylabel(ylabels[1])
ax2.legend(frameon=True)
ax2.set_title("Evening & Night Traffic Congestion")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("HR_68.pdf", bbox_inches="tight")
