
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for E-commerce Sales Analysis
x_sales_growth = np.random.normal(20, 5, 10)
y_sales_growth = np.random.normal(100, 20, 10)
x_sales_decline = np.random.normal(-10, 3, 5)
y_sales_decline = np.random.normal(50, 10, 5)
x_reviews_positive = np.random.normal(15, 4, 5)
y_reviews_positive = np.random.normal(80, 15, 5)
xlabel = "Weekly Sales Growth (%)"
ylabel = "Customer Satisfaction (%)"
ax1xlim = [-20, 30]
ax1ylim = [0, 150]
diffline1 = [[0, 0], [-20, 30], [0, 150]]
diffline2 = [[0, 0], [-10, 20], [-5, 60]]
annotaterecx1 = [-10, 20]
annotaterecy1 = [45, 60]
ax2xlim = [-10, 20]
ax2ylim = [45, 60]
plotup1 = [-10, 60]
plotdown1 = [-10, 45]
title = "E-commerce Sales and Customer Reviews"
supertitle = "Weekly Analysis"
legendlabels = ["Sales Growth", "Sales Decline", "Positive Reviews"]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
fig.suptitle(supertitle, fontsize=16)

# Scatter plots
ax1.scatter(x_sales_growth, y_sales_growth, marker="o", color="#1f77b4", label=legendlabels[0])
ax1.scatter(x_sales_decline, y_sales_decline, marker="x", color="#d62728", label=legendlabels[1])
ax1.scatter(x_reviews_positive, y_reviews_positive, marker="s", color="#2ca02c", label=legendlabels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="#ff9896", alpha=0.2)
ax1.fill_betweenx(y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="#aec7e8", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=0.5)
ax1.plot(diffline1[0], diffline1[2], color="black", lw=0.5)

ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[1], annotaterecy1[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[0]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[0]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotaterecx1[1], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=0.5,
)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend()

# Scatter plots
ax2.scatter(x_sales_growth, y_sales_growth, marker="o", color="#1f77b4")
ax2.scatter(x_sales_decline, y_sales_decline, marker="x", color="#d62728")
ax2.scatter(x_reviews_positive, y_reviews_positive, marker="s", color="#2ca02c")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="#ff9896", alpha=0.2)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="#aec7e8", alpha=0.2)
# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=0.5)
ax2.plot(diffline2[0], diffline2[2], color="black", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_21.pdf", bbox_inches="tight")

