
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Economic data simulation
# GDP growth rate for three different sectors
x_sector1 = np.random.normal(-2, 0.5, 10)
y_sector1 = np.random.normal(2, 0.5, 10)
x_sector1_additional = np.random.normal(-15, 2, 10)
y_sector1_additional = np.random.normal(10, 2, 10)
x_sector1_total = np.concatenate([x_sector1, x_sector1_additional])
y_sector1_total = np.concatenate([y_sector1, y_sector1_additional])

# Unemployment rates for three different demographic groups
x_group1 = np.random.normal(-3, 0.5, 5)
y_group1 = np.random.normal(4, 0.5, 5)

# Inflation rates based on different categories of goods/services
x_category1 = np.random.normal(-1, 0.2, 5)
y_category1 = np.random.normal(1, 0.2, 5)

# Labels and limits
xlabel = "GDP Growth Rate (%)"
ylabel = "Unemployment Rate (%)"
title = "Economic Indicators Visualization"
legendlabels = ["Sector Growth", "Demographic Unemployment", "Category Inflation"]

ax1xlim = [-20, 5]
ax1ylim = [-5, 15]
diffline1 = [[0, 0], [-20, 5], [-5, 15]]
diffline2 = [[0, 0], [-5, 3], [-5, 6]]
annotaterecx1 = [-5, 3]
annotaterecy1 = [-2, 6]
ax2xlim = [-5, 2]
ax2ylim = [-2, 6]
plotup1 = [-5, 6]
plotdown1 = [-5, -2]
suptitle="Economic Data Visualization"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
# Scatter plots
ax1.scatter(x_sector1_total, y_sector1_total, marker="P", color="#1f77b4", label=legendlabels[0])
ax1.scatter(x_group1, y_group1, marker="X", color="#ff7f0e", label=legendlabels[1])
ax1.scatter(x_category1, y_category1, marker="o", color="#2ca02c", label=legendlabels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="red", alpha=0.1)
ax1.fill_betweenx(y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="blue", alpha=0.1)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", linestyle='dashdot', lw=0.7)
ax1.plot(diffline1[0], diffline1[2], color="black", linestyle='dashdot', lw=0.7)

ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[1], annotaterecy1[1]], color="black", linestyle='dotted', lw=0.7)
ax1.plot([annotaterecx1[0], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[0]], color="black", linestyle='dotted', lw=0.7)
ax1.plot([annotaterecx1[0], annotaterecx1[0]], [annotaterecy1[0], annotaterecy1[1]], color="black", linestyle='dotted', lw=0.7)
ax1.plot([annotaterecx1[1], annotaterecx1[1]], [annotaterecy1[0], annotaterecy1[1]], color="black", linestyle='dotted', lw=0.7)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc='upper left')

# Scatter plots
ax2.scatter(x_sector1_total, y_sector1_total, marker="P", color="#1f77b4", label=legendlabels[0])
ax2.scatter(x_group1, y_group1, marker="X", color="#ff7f0e", label=legendlabels[1])
ax2.scatter(x_category1, y_category1, marker="o", color="#2ca02c", label=legendlabels[2])

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="red", alpha=0.1)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="blue", alpha=0.1)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", linestyle='dashdot', lw=0.7)
ax2.plot(diffline2[0], diffline2[2], color="black", linestyle='dashdot', lw=0.7)
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.legend(loc='upper left')

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(plt.Line2D((main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"))
fig.add_artist(plt.Line2D((main_plot_down[0], inset_down[0]), (main_plot_down[1], inset_down[1]), color="gray"))

# ===================
# Part 4: Saving Output
# ===================
plt.suptitle(suptitle)
plt.tight_layout()
plt.savefig("PIP_23.pdf", bbox_inches="tight")
