
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate transportation domain dummy data
months = np.arange(12)
cars = np.random.randint(200, 1000, size=12)
bicycles = np.random.randint(100, 800, size=12)

labels = ["Cars", "Bicycles"]
xlabel = "Month"
xlim = [-0.5, 11.5]
ylim = [0, 2000]
ylabel = "Number of Units Sold"
xticks = np.arange(12)
yticks = np.arange(0, 2000, 500)

left, bottom, width, height = [0.2, 0.6, 0.3, 0.3]
insetxlim = [-0.5, 5.5]
insetxticks = np.arange(6)
insetylim = [0, 1000]
insetyticks = np.arange(0, 1000, 250)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax_main = plt.subplots(figsize=(12, 8))
bar_width = 0.4
colors = ['#444444', '#FF5733']  # Metallic gray and vibrant red

# Main Plot
ax_main.bar(months, cars, width=bar_width, color=colors[0], align="center", label=labels[0], edgecolor="white", hatch='/')
ax_main.bar(months + bar_width, bicycles, width=bar_width, color=colors[1], align="center", label=labels[1], edgecolor="white", hatch='\\')

# Labels and grid
ax_main.set_xlabel(xlabel)
ax_main.set_xlim(xlim)
ax_main.set_xticks(xticks)
ax_main.set_xticklabels([f'Month {i+1}' for i in xticks], rotation=45)
ax_main.set_ylabel(ylabel)
ax_main.set_ylim(ylim)
ax_main.set_yticks(yticks)
ax_main.legend(loc="upper right", prop={"size": 14})
ax_main.set_title('Monthly Units Sold: Cars vs Bicycles')
ax_main.grid(axis='y', linestyle='--', alpha=0.7)

# Inset Plot
ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(months[:6], cars[:6], width=bar_width, color=colors[0], align="center", edgecolor="white", hatch='/')
ax_inset.bar(months[:6] + bar_width, bicycles[:6], width=bar_width, color=colors[1], align="center", edgecolor="white", hatch='\\')

# Inset Labels and grid
ax_inset.set_xlim(insetxlim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_xticklabels([f'Month {i+1}' for i in insetxticks])
ax_inset.set_ylim(insetylim)
ax_inset.set_yticks(insetyticks)
ax_inset.grid(axis='y', linestyle='--', alpha=0.7)

# Adding lines to connect the plots
main_plot_left = ax_main.transData.transform_point((0, cars[0]))
main_plot_right = ax_main.transData.transform_point((5, cars[5]))

inset_left = ax_inset.transData.transform_point((0, 0))
inset_right = ax_inset.transData.transform_point((5, 0))

main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

fig.add_artist(plt.Line2D((main_plot_left[0], inset_left[0]), (main_plot_left[1], inset_left[1]), color="gray"))
fig.add_artist(plt.Line2D((main_plot_right[0], inset_right[0]), (main_plot_right[1], inset_right[1]), color="gray"))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_24.pdf", bbox_inches="tight")
