
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generate some dummy data for the law domain
civil_cases = [500, 600, 700, 800, 900, 1000, 1100, 1200, 1300, 1400, 1500]
criminal_cases = [300, 400, 500, 600, 700, 800, 900, 1000, 1100, 1200, 1300]
years = range(2011, 2022)
labels = ["Civil Cases", "Criminal Cases"]
xlabel = "Years"
xlim = [2010.5, 2021.5]
ylim = [0, 3300]
ylabel = "Number of Cases"
xticks = np.arange(2011, 2022, 1)
yticks = np.arange(0, 3301, 500)
left, bottom, width, height = [0.2, 0.5, 0.3, 0.3]
insetxlim = [2010.5, 2016.5]
insetxticks = np.arange(2011, 2017, 1)
insetylim = [0, 2200]
insetyticks = np.arange(0, 2201, 300)
mainpointleft = [2011, 1300]
mainpointright = [2016, 1100]
insetleft = [2011, 0]
insetright = [2016, 0]
title = "Number of Cases Handled by Courts Over Years"
suptitle = "Analysis of Civil and Criminal Cases"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(12, 7))
bar_width = 0.3  # Slightly less than the bin width to create a gap
ax_main.bar(
    years,
    civil_cases,
    width=bar_width,
    color="#8B4513",  # SaddleBrown color for civil cases
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    years,
    criminal_cases,
    width=bar_width,
    color="#A52A2A",  # Brown color for criminal cases
    align="center",
    bottom=civil_cases,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xlabel, fontsize=14)
ax_main.set_xlim(xlim)
ax_main.set_xticks(xticks)
ax_main.set_ylabel(ylabel, fontsize=14)
ax_main.set_ylim(ylim)
ax_main.set_yticks(yticks)
ax_main.legend(loc="upper left", prop={"size": 12})
ax_main.grid()
ax_main.set_title(title, fontsize=16)
fig.suptitle(suptitle, fontsize=18)

# Create inset plot with adjusted bar widths and white borders
ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(
    years[:6],
    civil_cases[:6],
    width=bar_width,
    color="#8B4513",
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    years[:6],
    criminal_cases[:6],
    width=bar_width,
    color="#A52A2A",
    align="center",
    bottom=civil_cases[:6],
    edgecolor="white",
)
ax_inset.set_xlim(insetxlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(insetxticks)  # Zoom in on the right part of the data
ax_inset.set_ylim(insetylim)
ax_inset.set_yticks(insetyticks)
ax_inset.grid()

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainpointleft)
main_plot_right = ax_main.transData.transform_point(mainpointright)

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(insetleft)
inset_right = ax_inset.transData.transform_point(insetright)

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_25.pdf", bbox_inches="tight")
