
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
seasons = ["Winter", "Spring", "Summer", "Autumn"]
forest_temps = [0, 10, 20, 5]
desert_temps = [15, 25, 40, 20]
ocean_temps = [5, 15, 25, 10]
mountains_temps = [-5, 5, 15, 0]
labels = ["Forest", "Desert", "Ocean", "Mountains"]

# Inset parameters
insertax1 = [0.45, 0.2, 0.1, 0.3]
insertylim1 = [0, 15]
insertxlim1 = [0.5, 1.5]
insertax2 = [0.8, 0.2, 0.1, 0.3]
insertylim2 = [-5, 10]
insertxlim2 = [2.5, 3.5]

# Text labels
xlabel = "Seasons"
ylabel = "Average Temperature (°C)"
title = "Average Temperature by Season and Ecosystem"
insetaxes = [0.4, 0.2, 0.1, 0.3]
arrowend1 = [0.5, 0.4]
arrowend2 = [0.8, 0.2]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))

ax.plot(seasons, forest_temps, color="#1f77b4", linestyle='-', marker='o', markersize=10, label=labels[0])
ax.plot(seasons, desert_temps, color="#ff7f0e", linestyle='--', marker='s', markersize=10, label=labels[1])
ax.plot(seasons, ocean_temps, color="#2ca02c", linestyle='-.', marker='^', markersize=10, label=labels[2])
ax.plot(seasons, mountains_temps, color="#d62728", linestyle=':', marker='D', markersize=10, label=labels[3])

# Create the inset with the zoomed-in view
ax_inset1 = fig.add_axes(insertax1)
ax_inset1.plot(seasons, forest_temps, color="#1f77b4", linestyle='-', marker='o')
ax_inset1.plot(seasons, desert_temps, color="#ff7f0e", linestyle='--', marker='s')
ax_inset1.plot(seasons, ocean_temps, color="#2ca02c", linestyle='-.', marker='^')
ax_inset1.plot(seasons, mountains_temps, color="#d62728", linestyle=':', marker='D')
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Create the inset with the zoomed-in view
ax_inset2 = fig.add_axes(insertax2)
ax_inset2.plot(seasons, forest_temps, color="#1f77b4", linestyle='-', marker='o')
ax_inset2.plot(seasons, desert_temps, color="#ff7f0e", linestyle='--', marker='s')
ax_inset2.plot(seasons, ocean_temps, color="#2ca02c", linestyle='-.', marker='^')
ax_inset2.plot(seasons, mountains_temps, color="#d62728", linestyle=':', marker='D')
ax_inset2.spines["bottom"].set_color("black")
ax_inset2.spines["left"].set_color("black")
ax_inset2.spines["top"].set_color("black")
ax_inset2.spines["right"].set_color("black")
ax_inset2.set_ylim(insertylim2)
ax_inset2.set_xlim(insertxlim2)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)

# Annotate with arrows
ax.annotate(
    "",
    xy=(seasons[1], mountains_temps[1]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)
ax.annotate(
    "",
    xy=(seasons[3], mountains_temps[3]),
    xytext=arrowend2,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_27.pdf", bbox_inches="tight")
