
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate some dummy data for agriculture
moisture_levels = [0.0, 0.05, 0.10, 0.15, 0.20, 0.25, 0.30, 0.35, 0.4, 0.45, 0.5]
wheat_yield = [
    600,
    750,
    900,
    1100,
    1300,
    1200,
    1000,
    800,
    600,
    500,
    400,
]  # Wheat yield
corn_yield = [
    400,
    620,
    850,
    1000,
    1100,
    1050,
    900,
    720,
    550,
    450,
    300,
]  # Corn yield
labels = ["Wheat", "Corn"]
xmainlabel = "Moisture Levels"
xmainlim = [-0.1, 0.8]
xmainticks = [0.0, 0.2, 0.4, 0.6]
ymainlabel = "Yield (kg/hectare)"
ymainlim = [0, 3000]
ymainticks = [0, 300, 600, 900, 1200, 1500, 1800, 2100, 2400, 2700, 3000]

xinsetlim = [0.20, 0.55]
xinsetticks = [0.25, 0.30, 0.35, 0.40, 0.45, 0.50]
yinsetlim = [0, 3000]
yinsetticks = [0, 300, 600, 900, 1200, 1500, 1800, 2100, 2400, 2700, 3000]
# Create inset plot with adjusted bar widths and white borders
left, bottom, width, height = [0.5, 0.6, 0.3, 0.3]
mainplotline = [(0.235, 600), (0.55, 600)]
maininsetline = [(0.20, 0), (0.55, 0)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.05  # Slightly less than the bin width to create a gap
ax_main.bar(
    moisture_levels,
    wheat_yield,
    width=bar_width,
    color="#8FBF73",  # Earthy green color
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    moisture_levels,
    corn_yield,
    width=bar_width,
    color="#C99069",  # Earthy brown color
    align="center",
    bottom=wheat_yield,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper right", prop={"size": 16})
ax_main.grid(True, linestyle='--', linewidth=0.5)

ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(
    moisture_levels[5:],
    wheat_yield[5:],
    width=bar_width,
    color="#8FBF73",
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    moisture_levels[5:],
    corn_yield[5:],
    width=bar_width,
    color="#C99069",
    align="center",
    bottom=wheat_yield[5:],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(xinsetticks)  # Zoom in on the right part of the data
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)
ax_inset.grid(True, linestyle='--', linewidth=0.5)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_30.pdf", bbox_inches="tight")
