
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data to simulate blood pressure trends for different age groups
x = np.linspace(0, 12, 100)  # Representing months of a year
y1 = 120 + 10 * np.sin(x) + np.random.normal(0, 2, 100)  # Age group 20-30
y2 = 130 + 10 * np.sin(x + 0.5) + np.random.normal(0, 2, 100)  # Age group 31-40
y3 = 140 + 10 * np.sin(x + 1.0) + np.random.normal(0, 2, 100)  # Age group 41-50
y4 = 150 + 10 * np.sin(x + 1.5) + np.random.normal(0, 2, 100)  # Age group 51-60

# Labels and Plot Types
label_age_group_20_30 = "Age 20-30"
label_age_group_31_40 = "Age 31-40"
label_age_group_41_50 = "Age 41-50"
label_age_group_51_60 = "Age 51-60"

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Blood Pressure (mm Hg)"
zoomed_in_axes = [0.5, 0.70, 0.3, 0.20]
xlim_values = [10, 12]
ylim_values = [115, 155]
xticks_values = [10, 11, 12]
yticks_values = [120, 130, 140, 150]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the curves with enhanced styles
ax.plot(x, y1, "d-", color='#1f77b4', label=label_age_group_20_30, linewidth=2)
ax.plot(x, y2, "s--", color='#ff7f0e', label=label_age_group_31_40, linewidth=2)
ax.plot(x, y3, "^:", color='#2ca02c', label=label_age_group_41_50, linewidth=2)
ax.plot(x, y4, "o-.", color='#d62728', label=label_age_group_51_60, linewidth=2)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title('Average Blood Pressure Trends Over a Year')
ax.set_ylim(100,190)
# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)
ax_inset.plot(x, y1, "d-", color='#1f77b4')
ax_inset.plot(x, y2, "s--", color='#ff7f0e')
ax_inset.plot(x, y3, "^:", color='#2ca02c')
ax_inset.plot(x, y4, "o-.", color='#d62728')
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.grid(True, linestyle='--', alpha=0.7)  # Add grid lines for readability
ax_inset.spines["bottom"].set_color("black")  
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="upper left", bbox_to_anchor=(1, 1))

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_36.pdf", bbox_inches="tight")
