
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Energy consumption and renewable energy production data
np.random.seed(0)
consumption_region_a = np.random.normal(300, 30, 10)  # Energy consumption (Region A)
renewable_region_a = np.random.normal(100, 15, 10)  # Renewable energy (Region A)
consumption_region_b = np.random.normal(400, 40, 10)  # Energy consumption (Region B)
renewable_region_b = np.random.normal(150, 20, 10)  # Renewable energy (Region B)
consumption_region_ab = np.concatenate([consumption_region_a, consumption_region_b])
renewable_region_ab = np.concatenate([renewable_region_a, renewable_region_b])

# Smaller regions
consumption_region_c = np.random.normal(350, 25, 5)  # Energy consumption (Region C)
renewable_region_c = np.random.normal(110, 10, 5)  # Renewable energy (Region C)
consumption_region_d = np.random.normal(320, 22, 5)  # Energy consumption (Region D)
renewable_region_d = np.random.normal(120, 12, 5)  # Renewable energy (Region D)

# Labels and plot limits
xlabel = "Energy Consumption (GWh)"
ylabel = "Renewable Energy Production (GWh)"
title = "Energy Consumption vs Renewable Energy Production"
annotation_text = "Region Highlight"
ax1xlim = [250, 500]
ax1ylim = [80, 180]
main_diff_line = [[80, 80], [250, 500], [80, 180]]
inset_diff_line = [[80, 80], [300, 450], [90, 170]]
annotation_rect_x = [300, 450]
annotation_rect_y = [90, 170]
ax2xlim = [300, 450]
ax2ylim = [90, 170]
main_plot_upper = [300, 170]
main_plot_lower = [300, 90]

labels = ["Region A & B", "Region C", "Region D"]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))
# Scatter plots
ax1.scatter(
    consumption_region_ab, renewable_region_ab, marker="^", color="#005ab5", label=labels[0]
)
ax1.scatter(consumption_region_c, renewable_region_c, marker="o", color="#d3651e", label=labels[1])
ax1.scatter(consumption_region_d, renewable_region_d, marker="s", color="#1ea755", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[120, ax1ylim[1]], x1=ax1xlim[0], x2=375, color="purple", alpha=0.2)
ax1.fill_betweenx(y=[120, ax1ylim[0]], x1=375, x2=ax1xlim[1], color="orange", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(main_diff_line[1], main_diff_line[0], color="gray", lw=0.5)
ax1.plot(main_diff_line[0], main_diff_line[2], color="gray", lw=0.5)

ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[1], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[0]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[0]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[1], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title)

# Scatter plots
ax2.scatter(consumption_region_ab, renewable_region_ab, marker="^", color="#005ab5")
ax2.scatter(consumption_region_c, renewable_region_c, marker="o", color="#d3651e")
ax2.scatter(consumption_region_d, renewable_region_d, marker="s", color="#1ea755")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 120], x1=ax2xlim[0], x2=375, color="purple", alpha=0.2)
ax2.fill_betweenx(y=[120, ax2ylim[0]], x1=375, x2=ax2xlim[1], color="orange", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(inset_diff_line[1], inset_diff_line[0], color="gray", lw=0.5)
ax2.plot(inset_diff_line[0], inset_diff_line[2], color="gray", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(main_plot_upper)
ax1_plot_down = ax1.transData.transform_point(main_plot_lower)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(main_plot_upper)
ax2_down = ax2.transData.transform_point(main_plot_lower)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_56.pdf", bbox_inches="tight")
