# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample geographical data (temperature and humidity)
import numpy as np

np.random.seed(0)
region_temp_A = np.random.normal(20, 5, 10)  # Temperature for Region A
region_temp_B = np.random.normal(25, 7, 10)  # Temperature for Region B
region_humidity_A = np.random.normal(60, 10, 10)  # Humidity for Region A
region_humidity_B = np.random.normal(55, 8, 10)  # Humidity for Region B
temperature_total = np.concatenate([region_temp_A, region_temp_B])
humidity_total = np.concatenate([region_humidity_A, region_humidity_B])

precip_A = np.random.normal(5, 2, 5)  # Precipitation for Region A
precip_B = np.random.normal(7, 1, 5)  # Precipitation for Region B

wind_A = np.random.normal(15, 4, 5)  # Wind speed for Region A
wind_B = np.random.normal(18, 3, 5)  # Wind speed for Region B

xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
ax1xlim = [10, 40]
ax1ylim = [30, 80]
diffline1 = [[0, 0], [10, 40], [30, 80]]
diffline2 = [[0, 0], [15, 25], [35, 65]]
annotaterecx1 = [15, 25]
annotaterecy1 = [35, 65]
ax2xlim = [15, 25]
ax2ylim = [35, 65]
plotup1 = [15, 60]
plotdown1 = [15, 35]

title = "Geographical Data Analysis"
supertitle = "Temperature and Humidity Correlations Across Regions"
label = [
    "Region A (Temperature vs. Humidity)",
    "Region B (Precipitation)",
    "Region C (Wind Speed)",
]
label2 = ["High-Temperature Zone", "Moderate-Temperature Zone"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
fig.suptitle(supertitle, fontsize=14)

# Scatter plots
ax1.scatter(
    temperature_total, humidity_total, marker="^", color="#FF6347", label=label[0]
)
ax1.scatter(precip_A, precip_B, marker="o", color="#4682B4", label=label[1])
ax1.scatter(wind_A, wind_B, marker="s", color="#2E8B57", label=label[2])

# Shaded regions
ax1.fill_betweenx(
    y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="#FF4500", alpha=0.2, label=label2[0]
)
ax1.fill_betweenx(
    y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="#98FB98", alpha=0.2, label=label2[1]
)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[1], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[0]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[0]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[1], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)

ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc="upper right")
ax1.set_title(title, fontsize=12)

# Scatter plots for the second axis
ax2.scatter(temperature_total, humidity_total, marker="^", color="#FF6347")
ax2.scatter(precip_A, precip_B, marker="o", color="#4682B4")
ax2.scatter(wind_A, wind_B, marker="s", color="#2E8B57")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="#FF4500", alpha=0.2)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="#98FB98", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_60.pdf", bbox_inches="tight")
