# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
equip_eff_S = np.random.normal(95, 15, 10)  # Efficiency of Satellite Equipment
equip_eff_F = np.random.normal(80, 10, 10)  # Efficiency of Fiber Optic Equipment
equip_cost_S = np.random.normal(120, 30, 10)  # Production Cost of Satellite Equipment
equip_cost_F = np.random.normal(90, 20, 10)  # Production Cost of Fiber Optic Equipment
equip_eff_total = np.concatenate([equip_eff_S, equip_eff_F])
equip_cost_total = np.concatenate([equip_cost_S, equip_cost_F])

reliability_rates_A = np.random.normal(85, 10, 5)  # Reliability Index for Type A
reliability_rates_B = np.random.normal(70, 5, 5)  # Reliability Index for Type B

maintenance_rates_A = np.random.normal(75, 7, 5)  # Maintenance Cost for Type A
maintenance_rates_B = np.random.normal(50, 8, 5)  # Maintenance Cost for Type B

xlabel = "Equipment Efficiency (%)"
ylabel = "Production Cost (million $)"
ax1xlim = [50, 150]
ax1ylim = [30, 170]
diffline1 = [[0, 0], [50, 150], [30, 170]]
diffline2 = [[0, 0], [50, 90], [40, 100]]
annotaterecx1 = [60, 110]
annotaterecy1 = [50, 120]
ax2xlim = [50, 90]
ax2ylim = [40, 100]
plotup1 = [50, 45]
plotdown1 = [50, 100]

label = [
    "Satellite Equipment",
    "Fiber Optic Equipment",
    "Radio Wave Equipment",
]
label2 = ["High Cost Zone", "Efficient Production Zone"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(
    equip_eff_total, equip_cost_total, marker="^", color="#1f78b4", label=label[0]
)
ax1.scatter(
    reliability_rates_A,
    reliability_rates_B,
    marker="o",
    color="#ff7f00",
    label=label[1],
)
ax1.scatter(
    maintenance_rates_A,
    maintenance_rates_B,
    marker="s",
    color="#6a3d9a",
    label=label[2],
)

# Shaded regions
ax1.fill_betweenx(
    y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="#e31a1c", alpha=0.2, label=label2[0]
)
ax1.fill_betweenx(
    y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="#33a02c", alpha=0.2, label=label2[1]
)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[1], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[0]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[0]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[1], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)

ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc="upper right")

# Scatter plots for the second axis
ax2.scatter(equip_eff_total, equip_cost_total, marker="^", color="#1f78b4")
ax2.scatter(reliability_rates_A, reliability_rates_B, marker="o", color="#ff7f00")
ax2.scatter(maintenance_rates_A, maintenance_rates_B, marker="s", color="#6a3d9a")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="#e31a1c", alpha=0.2)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="#33a02c", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_61.pdf", bbox_inches="tight")
