# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample transportation data (average speeds, fuel efficiency and congestion levels)
avg_speeds_cityA = np.random.normal(65, 10, 10)  # Average speeds in city A
avg_speeds_cityB = np.random.normal(55, 8, 10)  # Average speeds in city B
fuel_efficiency_A = np.random.normal(25, 5, 10)  # Fuel efficiency in city A
fuel_efficiency_B = np.random.normal(20, 4, 10)  # Fuel efficiency in city B
congestion_A = np.random.normal(30, 10, 10)  # Congestion levels in city A
congestion_B = np.random.normal(40, 15, 10)  # Congestion levels in city B
speeds_total = np.concatenate([avg_speeds_cityA, avg_speeds_cityB])
efficiency_total = np.concatenate([fuel_efficiency_A, fuel_efficiency_B])
congestion_total = np.concatenate([congestion_A, congestion_B])

xlabel = "Average Speed (mph)"
ylabel = "Fuel Efficiency (mpg)"
ax1xlim = [30, 100]
ax1ylim = [10, 35]
diffline1 = [[0, 0], [30, 100], [10, 35]]
diffline2 = [[0, 0], [45, 70], [20, 30]]
annotaterecx1 = [45, 70]
annotaterecy1 = [20, 30]
ax2xlim = [45, 70]
ax2ylim = [20, 30]
plotup1 = [50, 28]
plotdown1 = [50, 20]

label = [
    "Avg Speeds in City A",
    "Fuel Efficiency in City A",
    "Congestion Levels in City A",
]
label2 = ["High Congestion Zone", "Optimal Efficiency Zone"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(
    speeds_total, efficiency_total, marker="^", color="darkblue", label=label[0]
)
ax1.scatter(congestion_A, congestion_B, marker="o", color="darkgreen", label=label[1])
ax1.scatter(
    congestion_total, efficiency_total, marker="s", color="darkorange", label=label[2]
)

# Shaded regions
ax1.fill_betweenx(
    y=[0, ax1ylim[1]], x1=ax1xlim[0], x2=0, color="red", alpha=0.2, label=label2[0]
)
ax1.fill_betweenx(
    y=[0, ax1ylim[0]], x1=0, x2=ax1xlim[1], color="green", alpha=0.2, label=label2[1]
)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[1], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[0]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[0]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[1], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)

ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc="upper right")

# Scatter plots for the second axis
ax2.scatter(speeds_total, efficiency_total, marker="^", color="darkblue")
ax2.scatter(congestion_A, congestion_B, marker="o", color="darkgreen")
ax2.scatter(congestion_total, efficiency_total, marker="s", color="darkorange")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 0], x1=ax2xlim[0], x2=0, color="red", alpha=0.2)
ax2.fill_betweenx(y=[0, ax2ylim[0]], x1=0, x2=ax2xlim[1], color="green", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_62.pdf", bbox_inches="tight")
