# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
x = ["New York", "Los Angeles", "Chicago", "Houston"]
y1 = [55, 65, 50, 70]  # Year 1 average temperature (°F)
y2 = [57, 67, 52, 72]  # Year 2 average temperature (°F)
y3 = [59, 69, 54, 74]  # Year 3 average temperature (°F)
y4 = [61, 71, 56, 76]  # Year 4 average temperature (°F)
labels = ["Year 1", "Year 2", "Year 3", "Year 4"]
insertax1 = [0.6, 0.2, 0.1, 0.3]
insertylim1 = [50, 60]
insertxlim1 = [1.5, 2.5]
insertax2 = [0.88, 0.7, 0.1, 0.2]
insertylim2 = [65, 75]
insertxlim2 = [2.5, 3.5]
xlabel = "City"
ylabel = "Average Temperature (°F)"
title = "Average Annual Temperatures in Different Cities"
insetaxes = [0.6, 0.5, 0.1, 0.3]
arrowend1 = [0.65, 0.4]
arrowend2 = [0.93, 0.7]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))

ax.plot(x, y1, color="#FF5733", marker="o", linestyle="-", label=labels[0])
ax.plot(x, y2, color="#33FF57", marker="s", linestyle="--", label=labels[1])
ax.plot(x, y3, color="#3357FF", marker="d", linestyle="-.", label=labels[2])
ax.plot(x, y4, color="#FF33A1", marker="^", linestyle=":", label=labels[3])

# Create the first inset with the zoomed-in view
ax_inset1 = fig.add_axes(insetaxes)
ax_inset1.plot(x, y1, color="#FF5733", marker="o", linestyle="-")
ax_inset1.plot(x, y2, color="#33FF57", marker="s", linestyle="--")
ax_inset1.plot(x, y3, color="#3357FF", marker="d", linestyle="-.")
ax_inset1.plot(x, y4, color="#FF33A1", marker="^", linestyle=":")
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="lower right")
ax.grid(True)
ax.annotate(
    "",
    xy=(x[2], y3[2]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)


# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("PIP_63.pdf", bbox_inches="tight")
