# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
x = ["Q1", "Q2", "Q3", "Q4"]
y1 = [120, 150, 145, 140]  # Group A: Average weekly exercise time in minutes
y2 = [100, 110, 115, 125]  # Group B
y3 = [90, 105, 110, 120]  # Group C
y4 = [95, 100, 105, 115]  # Group D
labels = ["Group A", "Group B", "Group C", "Group D"]
xlabel = "Quarter"
ylabel = "Average Weekly Exercise Time (min)"
title = "Fitness Trends Over Quarters"
insetaxes = [0.6, 0.5, 0.1, 0.3]
insertax1 = [0.6, 0.2, 0.1, 0.3]
insertylim1 = [85, 145]
insertxlim1 = [1.5, 2.5]
insertax2 = [0.88, 0.7, 0.1, 0.2]
insertylim2 = [120, 150]
insertxlim2 = [0.8, 3.8]
arrowend1 = [0.65, 0.4]
arrowend2 = [0.93, 0.7]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(12, 8))

ax.plot(x, y1, color="#4CAF50", marker="o", linestyle="-", linewidth=2, label=labels[0])
ax.plot(
    x, y2, color="#2196F3", marker="s", linestyle="--", linewidth=2, label=labels[1]
)
ax.plot(
    x, y3, color="#FFC107", marker="^", linestyle="-.", linewidth=2, label=labels[2]
)
ax.plot(x, y4, color="#9C27B0", marker="d", linestyle=":", linewidth=2, label=labels[3])

# Create the first inset with the zoomed-in view
ax_inset1 = fig.add_axes(insetaxes)
ax_inset1.plot(x, y1, color="#4CAF50", marker="o", linestyle="-")
ax_inset1.plot(x, y2, color="#2196F3", marker="s", linestyle="--")
ax_inset1.plot(x, y3, color="#FFC107", marker="^", linestyle="-.")
ax_inset1.plot(x, y4, color="#9C27B0", marker="d", linestyle=":")
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)
ax_inset1.grid(True)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)
ax.annotate(
    "",
    xy=(x[2], y3[2]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)


# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("PIP_64.pdf", bbox_inches="tight")
