# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generate some energy usage data
renewable_energy = [
    200,
    400,
    700,
    1100,
    1600,
    2200,
    2900,
    3700,
    4500,
    5300,
    6000,
]  # Renewable Energy Usage (in GWh)
non_renewable_energy = [
    500,
    470,
    440,
    410,
    380,
    350,
    320,
    290,
    260,
    230,
    200,
]  # Non-Renewable Energy Usage (in GWh)
bins = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
labels = ["Renewable Energy", "Non-Renewable Energy"]
xmainlabel = "Time Frame (Years)"
xmainlim = [-0.1, 1.1]
xmainticks = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]
ymainlabel = "Energy Usage (in GWh)"
ymainlim = [0, 8000]
ymainticks = [0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000]

xinsetlim = [0.35, 1.0]
xinsetticks = [0.4, 0.6, 0.8, 1.0]
yinsetlim = [0, 6500]
yinsetticks = [0, 1000, 2000, 3000, 4000, 5000, 6000]

# Coordinates for lines connecting the plots (main and inset)
mainplotline = [(0.435, 0), (1.1, 0)]
maininsetline = [(0.4, 0), (1.0, 0)]
title = "Energy Usage Over Time"
subtitle = "Renewable vs Non-Renewable Energy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.05  # Slightly less than the bin width to create a gap
# Plotting the renewable energy usage
ax_main.bar(
    bins,
    renewable_energy,
    width=bar_width,
    color="#76c7c0",  # Aqua for Renewable Energy
    align="center",
    label=labels[0],
    edgecolor="white",
)
# Plotting the non-renewable energy usage
ax_main.bar(
    bins,
    non_renewable_energy,
    width=bar_width,
    color="#555555",  # Gray for Non-Renewable Energy
    align="center",
    bottom=renewable_energy,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper right", prop={"size": 16})
plt.title(title, fontsize=20)
plt.suptitle(subtitle, fontsize=12)

# Inset plot configuration
ax_inset = fig.add_axes([0.15, 0.45, 0.3, 0.4])
ax_inset.bar(
    bins[4:],
    renewable_energy[4:],
    width=bar_width,
    color="#76c7c0",
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    bins[4:],
    non_renewable_energy[4:],
    width=bar_width,
    color="#555555",
    align="center",
    bottom=renewable_energy[4:],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(xinsetticks)
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_67.pdf", bbox_inches="tight")
