# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================

import numpy as np

# Simulated Health Data for plotting

years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
admissions_diseaseA = np.array(
    [200, 400, 800, 1600, 3200, 6400]
)  # Exponential growth for Disease A
admissions_diseaseB = np.array(
    [500, 550, 600, 650, 700, 750]
)  # Linear growth for Disease B
recovery_diseaseA = np.array(
    [50, 150, 300, 600, 1200, 2400]
)  # Exponential growth for Disease A Recovery
recovery_diseaseB = np.array(
    [400, 430, 460, 490, 520, 550]
)  # Linear growth for Disease B Recovery

labels = [
    "Disease A Admissions | Exponential Growth",
    "Disease B Admissions | Linear Growth",
    "Disease A Recoveries | Exponential Growth",
    "Disease B Recoveries | Linear Growth",
]
xlabel = "Year"
ylabel = "Number of Cases"
title = "Hospital Admissions and Recoveries (2010-2020)"

# Labels and tick mark settings
xticks = years
yticks = np.linspace(0, 7000, 8)
yticklabels = [f"{int(x):,}" for x in yticks]
inset_axes = [0.5, 0.5, 0.25, 0.3]
inset_ylim = [0, 2500]
yticks_inset = np.linspace(0, 2500, 6)
x_years = [f"{int(x)}" for x in years]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data with different styles and colors
ax.plot(
    years, admissions_diseaseA, "o-", label=labels[0], color="#1f77b4"
)  # Blue for Disease A
ax.plot(
    years, admissions_diseaseB, "x--", label=labels[1], color="#2ca02c"
)  # Green for Disease B
ax.plot(
    years, recovery_diseaseA, "s-", label=labels[2], color="#ff7f0e"
)  # Orange for Disease A Recovery
ax.plot(
    years, recovery_diseaseB, "d--", label=labels[3], color="#d62728"
)  # Red for Disease B Recovery

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits and ticks
ax.set_ylim([0, 7000])
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

# Add a legend
ax.legend()

# Create an inset axis for Disease A data
ax_inset = fig.add_axes(inset_axes)
ax_inset.plot(years, admissions_diseaseA, "o-", color="#1f77b4")
ax_inset.plot(years, recovery_diseaseA, "s-", color="#ff7f0e")

# Adjust y-axis limits for inset
ax_inset.set_ylim(inset_ylim)
ax_inset.set_xlim([2010, 2020])
ax_inset.set_yticks(yticks_inset)

# Change x-axis tick labels to years
ax.set_xticks(years)
ax.set_xticklabels(x_years)
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(x_years)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_69.pdf", bbox_inches="tight")
