# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# --------------------
# Part 2: Data Preparation
# --------------------
# Generate New Data
import numpy as np

# Simulated Revenue Data for plotting
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
revenue_exp_google = np.array(
    [800000, 880000, 968000, 1064800, 1171280, 1288408]
)  # Exponential growth for Google
revenue_lin_google = np.array(
    [800000, 850000, 900000, 950000, 1000000, 1050000]
)  # Linear growth for Google
revenue_exp_amazon = np.array(
    [700000, 770000, 847000, 931700, 1024870, 1127357]
)  # Exponential growth for Amazon
revenue_lin_amazon = np.array(
    [700000, 740000, 780000, 820000, 860000, 900000]
)  # Linear growth for Amazon

# New Labels and tick mark settings
labels = [
    "Google | Exponential Growth",
    "Google | Linear Growth",
    "Amazon | Exponential Growth",
    "Amazon | Linear Growth",
]
xlabel = "Year"
ylabel = "Revenue (USD)"
title = "Revenue Growth of Google and Amazon (2010-2020)"

xticks = years
yticks = np.linspace(0, 1500000, 6)
yticklabels = [f"${int(x):,}" for x in yticks]
inset_axes = [0.22, 0.15, 0.3, 0.25]
inset_ylim = [600000, 1200000]
yticks_inset = np.linspace(600000, 1200000, 4)
x_years = [f"{int(x)}" for x in years]

# --------------------
# Part 3: Plot Configuration and Rendering
# --------------------
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data with different styles and colors
ax.plot(years, revenue_exp_google, "o-", label=labels[0], color="green")
ax.plot(years, revenue_lin_google, "x--", label=labels[1], color="green")
ax.plot(years, revenue_exp_amazon, "o-", label=labels[2], color="blue")
ax.plot(years, revenue_lin_amazon, "x--", label=labels[3], color="blue")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits and ticks
ax.set_ylim([0, 1500000])
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

# Add a legend
ax.legend()

# Create an inset axis for Google data
ax_inset = fig.add_axes(inset_axes)
ax_inset.plot(years, revenue_exp_google, "o-", color="green")
ax_inset.plot(years, revenue_lin_google, "x--", color="green")

# Adjust y-axis limits for inset
ax_inset.set_ylim(inset_ylim)
ax_inset.set_xlim([2010, 2020])
ax_inset.set_yticks(yticks_inset)

# Change x-axis tick labels to years
ax.set_xticks(years)
ax.set_xticklabels(x_years)
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(x_years)

# --------------------
# Part 4: Saving Output
# --------------------
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_70.pdf", bbox_inches="tight")
