# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated data for cumulative trade volume (in billions of dollars) for four countries over a 52-week period
np.random.seed(0)
weeks = np.linspace(1, 52, 52)
trade_volume_country1 = np.cumsum(np.random.poisson(2.5, 52))
trade_volume_country2 = np.cumsum(np.random.poisson(3.0, 52))
trade_volume_country3 = np.cumsum(np.random.poisson(1.8, 52))
trade_volume_country4 = np.cumsum(np.random.poisson(2.2, 52))

# Labels and Plot Types
label_country1 = "Country A"
label_country2 = "Country B"
label_country3 = "Country C"
label_country4 = "Country D"

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Cumulative Trade Volume (Billions of $)"
zoomed_in_axes = [0.15, 0.55, 0.25, 0.25]
xlim_values = [47, 52]
ylim_values = [
    min(
        trade_volume_country1[46],
        trade_volume_country2[46],
        trade_volume_country3[46],
        trade_volume_country4[46],
    ),
    max(
        trade_volume_country1[51],
        trade_volume_country2[51],
        trade_volume_country3[51],
        trade_volume_country4[51],
    )
    + 5,
]
xticks_values = list(range(47, 53))
yticks_values = list(range(int(ylim_values[0]), int(ylim_values[1]) + 5, 5))
title = "Cumulative Trade Volume Over 52 Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(12, 7))

# Plot the curves with distinct styles
ax.plot(
    weeks,
    trade_volume_country1,
    color="#1f77b4",
    linestyle="-",
    marker="o",
    label=label_country1,
)
ax.plot(
    weeks,
    trade_volume_country2,
    color="#ff7f0e",
    linestyle="--",
    marker="s",
    label=label_country2,
)
ax.plot(
    weeks,
    trade_volume_country3,
    color="#2ca02c",
    linestyle="-.",
    marker="^",
    label=label_country3,
)
ax.plot(
    weeks,
    trade_volume_country4,
    color="#d62728",
    linestyle=":",
    marker="d",
    label=label_country4,
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)
ax_inset.plot(weeks, trade_volume_country1, color="#1f77b4", linestyle="-", marker="o")
ax_inset.plot(weeks, trade_volume_country2, color="#ff7f0e", linestyle="--", marker="s")
ax_inset.plot(weeks, trade_volume_country3, color="#2ca02c", linestyle="-.", marker="^")
ax_inset.plot(weeks, trade_volume_country4, color="#d62728", linestyle=":", marker="d")
ax_inset.set_xlim(xlim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_73.pdf", bbox_inches="tight")
