
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [1, 2, 3, 4, 5]
wheat_yield = [2.5, 3.0, 3.5, 2.8, 4.0]  # Wheat yield in tons/acre
corn_yield = [2.0, 2.5, 3.0, 3.5, 4.0]   # Corn yield in tons/acre
rice_yield = [1.8, 2.0, 2.4, 2.6, 3.0]   # Rice yield in tons/acre
soybeans_yield = [1.5, 1.6, 1.8, 2.0, 2.5] # Soybeans yield in tons/acre

# Labels for legend
label_wheat = "Wheat Yield"
label_corn = "Corn Yield"
label_rice = "Rice Yield"
label_soybeans = "Soybeans Yield"

# Horizontal line value
axhline_value = 3.5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(9, 8))  # Adjusting figure size

# Plot limits
xlim_values = (1, 5)
ylim_values = (0, 5)

# Axis labels
xlabel_values = ["Year 1", "Year 2", "Year 3", "Year 4", "Year 5"]
ylabel_values = [0, 1, 2, 3, 4, 5]

# Axis ticks
xticks_values = years
yticks_values = [0, 1, 2, 3, 4, 5]

plt.plot(
    years,
    wheat_yield,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#8bc34a",
    markeredgecolor="#558b2f",
    markersize=12,
    color="#558b2f",
    label=label_wheat,
)
plt.plot(
    years,
    corn_yield,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ffeb3b",
    markeredgecolor="#fbc02d",
    markersize=12,
    color="#fbc02d",
    label=label_corn,
)
plt.plot(
    years,
    rice_yield,
    "^-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#03a9f4",
    markeredgecolor="#0288d1",
    markersize=12,
    color="#0288d1",
    label=label_rice,
)
plt.plot(
    years,
    soybeans_yield,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#6d4c41",
    markeredgecolor="#3e2723",
    markersize=12,
    color="#3e2723",
    label=label_soybeans,
)

# Filling the area under the curves
plt.fill_between(years, wheat_yield, corn_yield, color="#8bc34a", alpha=0.2)
plt.fill_between(years, corn_yield, rice_yield, color="#ffeb3b", alpha=0.2)
plt.fill_between(years, rice_yield, soybeans_yield, color="#03a9f4", alpha=0.2)
plt.fill_between(years, soybeans_yield, color="#6d4c41", alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="lower center", ncol=2, bbox_to_anchor=(0.5, -0.15), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Grid lines
plt.grid(True, linestyle='--', alpha=0.6)

# Title and labels
plt.title("Agricultural Crop Yields Over 5 Years")
plt.xlabel("Time (Years)")
plt.ylabel("Yield (tons/acre)")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_21.pdf", bbox_inches="tight")
