
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
x = np.arange(1, 13)  # 12 months
# Temperature data for four cities
y1 = [30, 32, 35, 33, 30, 28, 25, 26, 29, 32, 34, 31]
y2 = [25, 27, 30, 29, 25, 23, 20, 21, 23, 26, 28, 26]
y3 = [20, 22, 25, 24, 20, 18, 15, 17, 20, 23, 25, 22]
y4 = [15, 17, 20, 19, 15, 13, 10, 12, 15, 18, 20, 17]

# Labels for legend
label_city1 = "City 1 Temperature"
label_city2 = "City 2 Temperature"
label_city3 = "City 3 Temperature"
label_city4 = "City 4 Temperature"

# Horizontal line value for average comfortable temperature
axhline_value = 22

# Axis labels and title
xlabel_values = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
ylabel_values = range(10, 41, 5)  # y-axis values from 10 to 40 with a step of 5
chart_title = "Monthly Temperature Data"
chart_xlabel = "Months"
chart_ylabel = "Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size

# Plot limits
xlim_values = (1, 12)
ylim_values = (10, 40)

# Plot lines with different styles and colors
plt.plot(
    x,
    y1,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff7f0e",
    markeredgecolor="#d62728",
    markersize=8,
    color="#d62728",
    label=label_city1,
    linewidth=2
)
plt.plot(
    x,
    y2,
    "^-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1f77b4",
    markeredgecolor="#1f77b4",
    markersize=8,
    color="#1f77b4",
    label=label_city2,
    linewidth=2
)
plt.plot(
    x,
    y3,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ca02c",
    markeredgecolor="#2ca02c",
    markersize=8,
    color="#2ca02c",
    label=label_city3,
    linewidth=2
)
plt.plot(
    x,
    y4,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#9467bd",
    markeredgecolor="#9467bd",
    markersize=8,
    color="#9467bd",
    label=label_city4,
    linewidth=2
)

# Filling the area under the curves
plt.fill_between(x, y1, y2, color="#ff7f0e", alpha=0.3)
plt.fill_between(x, y2, y3, color="#1f77b4", alpha=0.3)
plt.fill_between(x, y3, y4, color="#2ca02c", alpha=0.3)
plt.fill_between(x, y4, color="#9467bd", alpha=0.3)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels and y-axis tick labels
plt.xticks(x, xlabel_values)
plt.yticks(ylabel_values)

# Adding title and labels
plt.title(chart_title, fontsize=14)
plt.xlabel(chart_xlabel, fontsize=12)
plt.ylabel(chart_ylabel, fontsize=12)

# Adding a legend
plt.legend(loc="upper right", frameon=False)

plt.gca().tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_23.pdf", bbox_inches="tight")
