
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot with new trends in the religion domain
time_points = np.array([0, 10, 20, 30, 40])
christianity = np.array([0.60, 0.62, 0.65, 0.67, 0.70]) + np.random.normal(0, 0.01, 5)
islam = np.array([0.55, 0.57, 0.60, 0.62, 0.66]) + np.random.normal(0, 0.015, 5)
hinduism = np.array([0.50, 0.52, 0.55, 0.57, 0.60]) + np.random.normal(0, 0.01, 5)
buddhism = np.array([0.65, 0.67, 0.69, 0.71, 0.74]) + np.random.normal(0, 0.012, 5)
control_group = np.linspace(0.55, 0.55, len(time_points))

# Extracted variables
fill_label_christianity = "Christianity"
fill_label_islam = "Islam"
fill_label_hinduism = "Hinduism"
fill_label_buddhism = "Buddhism"
plot_label_control = "Control Group"
title_text = "Influence of Religion on Mental Well-Being Over Time"
xlabel_text = "Time (Years)"
ylabel_text = "Mental Well-Being"
legend_title = "Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot with a different visualization style
plt.figure(figsize=(10, 6))

xlim_values = (min(time_points), max(time_points))
ylim_values = (0.48, 0.76)
xticks_values = time_points
yticks_values = [0.50, 0.55, 0.60, 0.65, 0.70, 0.75, 0.76]
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1

fill_colors = {
    "Christianity": "#FF9999",
    "Islam": "#99CC99",
    "Hinduism": "#FFCC99",
    "Buddhism": "#99CCFF"
}

plt.fill_between(
    time_points, christianity, color=fill_colors["Christianity"], alpha=0.5, label=fill_label_christianity
)
plt.fill_between(
    time_points, islam, color=fill_colors["Islam"], alpha=0.5, label=fill_label_islam
)
plt.fill_between(
    time_points, hinduism, color=fill_colors["Hinduism"], alpha=0.5, label=fill_label_hinduism
)
plt.fill_between(
    time_points, buddhism, color=fill_colors["Buddhism"], alpha=0.5, label=fill_label_buddhism
)
plt.plot(
    time_points, control_group, color="black", linestyle="--", linewidth=2, label=plot_label_control
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_29.pdf", bbox_inches="tight")
