
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

decade = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020]
publications_by_school = {
    "continental_philosophy": [100, 140, 200, 240, 300, 350, 400, 450],
    "analytic_philosophy": [120, 180, 230, 280, 310, 330, 370, 390],
    "pragmatism": [50, 60, 80, 90, 120, 150, 160, 170],
    "existentialism": [60, 70, 110, 130, 150, 170, 180, 200],
    "phenomenology": [80, 100, 140, 160, 170, 180, 190, 200],
}

# Extracted variables
legend_labels = list(publications_by_school.keys())
xlabel_value = "Decade"
ylabel_value = "Number of Publications"
title_value = "Philosophical Publications by School of Thought over Decades"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))

xlim_values = (1950, 2020)
ylim_values = (0, 2000)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = False
legend_ncol = 1
legend_bbox_to_anchor = (1.02, 1)
title_y_position = 1.02
colors = ["#4863A0", "#D16587", "#91C8E3", "#F19E8E", "#679D8B"]

ax.stackplot(
    decade,
    publications_by_school.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_33.pdf", bbox_inches="tight")
