
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

year = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2018]
influence_by_philosophy = {
    "stoicism": [150, 200, 250, 275, 300, 320, 330, 340],
    "existentialism": [100, 150, 270, 290, 310, 330, 340, 345],
    "nihilism": [50, 70, 150, 200, 220, 240, 260, 270],
    "postmodernism": [30, 50, 100, 150, 200, 250, 270, 280],
    "pragmatism": [20, 40, 80, 120, 170, 190, 210, 220],
}

# Extracted variables
legend_labels = list(influence_by_philosophy.keys())
xlabel_value = "Year"
ylabel_value = "Influence (arbitrary units)"
title_value = "Philosophical Influence Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

xlim_values = (1950, 2018)
ylim_values = (0, 1500)
legend_loc = "upper center"
legend_reverse = False
legend_frameon = False
legend_ncol = 5
legend_bbox_to_anchor = (0.5, 1.08)
title_y_position = 1.08

colors = ["#88c999", "#a088c9", "#c99888", "#c9a088", "#88a0c9"]

ax.stackplot(
    year,
    influence_by_philosophy.values(),
    labels=legend_labels,
    alpha=0.8,
    colors=colors,
    linewidths=2.5,
    edgecolor="gray",
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position, fontsize=14)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_35.pdf", bbox_inches="tight")
