
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
years = [2010, 2012, 2014, 2016, 2018, 2020]
abstract_popularity = [20, 23, 25, 28, 30, 27]  # Popularity of Abstract Art (%)
realism_popularity = [40, 38, 35, 32, 30, 28]  # Popularity of Realism (%)
digital_popularity = [10, 15, 20, 25, 35, 45]  # Popularity of Digital Art (%)

# Labels for legend
label_abstract = "Abstract Art"
label_realism = "Realism"
label_digital = "Digital Art"

# Title and labels
plot_title = "Popularity of Art Styles Over the Years"
xlabel_text = "Years"
ylabel_text = "Popularity (%)"

xlim_values = (2010, 2020)
ylim_values = (0, 50)

# Axis labels
xlabel_values = ["2010", "2012", "2014", "2016", "2018", "2020"]
ylabel_values = [0, 10, 20, 30, 40, 50]

# Axis ticks
xticks_values = years
yticks_values = [0, 10, 20, 30, 40, 50]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits

# Plotting the data
title_fontsize = 16
label_fontsize = 14
title_pad = 20
plt.figure(figsize=(12, 8))  # Adjusting figure size to fit better
plt.plot(
    years,
    abstract_popularity,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1f77b4",
    markeredgecolor="#1f77b4",
    markersize=10,
    color="#1f77b4",
    label=label_abstract,
)
plt.plot(
    years,
    realism_popularity,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#d62728",
    markeredgecolor="#d62728",
    markersize=10,
    color="#d62728",
    label=label_realism,
)
plt.plot(
    years,
    digital_popularity,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ca02c",
    markeredgecolor="#2ca02c",
    markersize=10,
    color="#2ca02c",
    label=label_digital,
)

# Filling the area under the curves
plt.fill_between(years, abstract_popularity, realism_popularity, color="#1f77b4", alpha=0.4)
plt.fill_between(years, realism_popularity, digital_popularity, color="#d62728", alpha=0.4)
plt.fill_between(years, digital_popularity, 0, color="#2ca02c", alpha=0.4)

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis and y-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding title and labels
plt.title(plot_title, fontsize=title_fontsize, pad=title_pad)
plt.xlabel(xlabel_text, fontsize=label_fontsize)
plt.ylabel(ylabel_text, fontsize=label_fontsize)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_38.pdf", bbox_inches="tight")
