
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting (Observation of Different Particles over Years)
years = [2015, 2016, 2017, 2018, 2019]
alpha_particles = [100, 150, 120, 170, 180]
beta_particles = [200, 210, 215, 220, 230]
gamma_particles = [80, 85, 90, 95, 100]
delta_particles = [50, 55, 60, 65, 70]

# Labels for legend
label_alpha = "Alpha Particles"
label_beta = "Beta Particles"
label_gamma = "Gamma Particles"
label_delta = "Delta Particles"

# Horizontal line value
axhline_value = 120

# Axis labels
xlabel_values = ["2015", "2016", "2017", "2018", "2019"]
ylabel_values = [50, 100, 150, 200, 250]

# Plot limits
xlim_values = (2015, 2019)
ylim_values = (0, 250)

# Axis ticks
xticks_values = years
yticks_values = [50, 100, 150, 200, 250]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years,
    alpha_particles,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff9999",
    markeredgecolor="#cc6666",
    markersize=10,
    color="#cc6666",
    label=label_alpha,
)
plt.plot(
    years,
    beta_particles,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#99ccff",
    markeredgecolor="#6699cc",
    markersize=10,
    color="#6699cc",
    label=label_beta,
)
plt.plot(
    years,
    gamma_particles,
    "^--",
    clip_on=False,
    zorder=10,
    markerfacecolor="#99ff99",
    markeredgecolor="#66cc66",
    markersize=10,
    color="#66cc66",
    label=label_gamma,
)
plt.plot(
    years,
    delta_particles,
    "d-.",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ffcc99",
    markeredgecolor="#cc9966",
    markersize=10,
    color="#cc9966",
    label=label_delta,
)

# Filling the area under the curves
plt.fill_between(years, alpha_particles, beta_particles, color="#ff9999", alpha=0.2)
plt.fill_between(
    years, beta_particles, gamma_particles, color="#99ccff", alpha=0.2
)
plt.fill_between(years, gamma_particles, delta_particles, color="#99ff99", alpha=0.2)
plt.fill_between(years, delta_particles, color="#ffcc99", alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis、y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend at the bottom
plt.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_40.pdf", bbox_inches="tight")
