
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# New data imports
import numpy as np

# Data for plotting (Annual Rainfall of Different Regions over Years)
years = [2015, 2016, 2017, 2018, 2019]
region_a_rainfall = [850, 900, 870, 920, 940]
region_b_rainfall = [750, 780, 790, 820, 850]
region_c_rainfall = [650, 670, 680, 690, 710]
region_d_rainfall = [550, 580, 600, 630, 640]

# Labels for legend
label_region_a = "Region A Rainfall"
label_region_b = "Region B Rainfall"
label_region_c = "Region C Rainfall"
label_region_d = "Region D Rainfall"

# Horizontal line value
axhline_value = 800

# Plot limits
xlim_values = (2015, 2019)
ylim_values = (500, 1000)

# Axis labels
xlabel_values = ["2015", "2016", "2017", "2018", "2019"]
ylabel_values = [500, 600, 700, 800, 900, 1000]

# Axis ticks
xticks_values = years
yticks_values = [500, 600, 700, 800, 900, 1000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years,
    region_a_rainfall,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1b9e77",
    markeredgecolor="#1b9e77",
    markersize=10,
    color="#1b9e77",
    label=label_region_a,
)
plt.plot(
    years,
    region_b_rainfall,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#d95f02",
    markeredgecolor="#d95f02",
    markersize=10,
    color="#d95f02",
    label=label_region_b,
)
plt.plot(
    years,
    region_c_rainfall,
    "^--",
    clip_on=False,
    zorder=10,
    markerfacecolor="#7570b3",
    markeredgecolor="#7570b3",
    markersize=10,
    color="#7570b3",
    label=label_region_c,
)
plt.plot(
    years,
    region_d_rainfall,
    "d-.",
    clip_on=False,
    zorder=10,
    markerfacecolor="#e7298a",
    markeredgecolor="#e7298a",
    markersize=10,
    color="#e7298a",
    label=label_region_d,
)

# Filling the area under the curves
plt.fill_between(years, region_a_rainfall, region_b_rainfall, color="#1b9e77", alpha=0.2)
plt.fill_between(years, region_b_rainfall, region_c_rainfall, color="#d95f02", alpha=0.2)
plt.fill_between(years, region_c_rainfall, region_d_rainfall, color="#7570b3", alpha=0.2)
plt.fill_between(years, region_d_rainfall, color="#e7298a", alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend at the bottom
plt.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# Adding title
plt.title("Annual Rainfall of Different Regions (2015-2019)")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_41.pdf", bbox_inches="tight")
