
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# Sample data for 12 months
months = np.arange(1, 13)
running_distance = np.random.uniform(5, 15, size=12)
cycling_distance = 20 + 10 * np.cos(np.pi * months / 6)

# Extracted variables for labels and settings
running_label = "Running Distance (km)"
cycling_label = "Cycling Distance (km)"

legend_labels = ["Running", "Cycling"]
running_ylabel = "Running Distance (km)"
cycling_ylabel = "Cycling Distance (km)"
monthly_xlabel = "Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
running_ylim = [0, 20]
cycling_ylim = [10, 30]
months_xticks = np.arange(1, 13, 1)
months_xlim = [1, 12]
yticks_running = np.arange(0, 21, 5)
yticks_cycling = np.arange(10, 31, 5)
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, -0.15)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 23))

# Plot Running Distance
ax1.plot(months, running_distance, "o-", color="#32CD32", label=running_label)
ax1.set_ylim(running_ylim)
ax1.set_xlim(months_xlim)
ax1.set_xticks(months_xticks)
ax1.set_ylabel(running_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True)

# Plot Cycling Distance
ax2.plot(months, cycling_distance, "s--", color="#FFA500", label=cycling_label)
ax2.set_ylim(cycling_ylim)
ax2.set_xlim(months_xlim)
ax2.set_yticks(yticks_cycling)
ax2.set_xticks(months_xticks)
ax2.set_xlabel(monthly_xlabel)
ax2.set_ylabel(cycling_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True)

# Create custom legend
green_dot = mlines.Line2D(
    [], [], color="#32CD32", marker="o", markersize=8, label=legend_labels[0], linestyle="None"
)
orange_square = mlines.Line2D(
    [], [], color="#FFA500", marker="s", markersize=8, label=legend_labels[1], linestyle="None"
)
plt.legend(
    handles=[green_dot, orange_square],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_45.pdf", bbox_inches="tight")
