
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for 12 months
months = np.arange(1, 13)
stock_prices = 100 + 20 * np.sin(np.pi * months / 6) + np.random.normal(0, 5, 12)
trading_volume = np.random.uniform(5000, 15000, size=12)

# Extracted variables for labels and settings
stock_price_label = "Stock Price ($)"
trading_volume_label = "Trading Volume"

legend_labels = ["Stock Price", "Trading Volume"]
stock_price_ylabel = "Stock Price ($)"
trading_volume_ylabel = "Trading Volume"
months_xlabel = "Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
stock_price_ylim = [80, 140]
trading_volume_ylim = [4000, 16000]
months_xticks = np.arange(1, 13, 1)
months_xlim = [1, 12]
yticks_stock_prices = np.arange(80, 141, 10)
yticks_trading_volume = np.arange(4000, 17000, 2000)
legend_loc = "upper left"
legend_bbox_to_anchor = (0.85, 1)
legend_ncol = 1
legend_frameon = True

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 23))

# Plot Stock Prices
ax1.plot(months, stock_prices, "o--", color="#2ca02c", label=stock_price_label, linewidth=2)
ax1.set_ylim(stock_price_ylim)
ax1.set_xlim(months_xlim)
ax1.set_xticks(months_xticks)
ax1.set_yticks(yticks_stock_prices)
ax1.set_ylabel(stock_price_ylabel)
ax1.tick_params(axis="both", which="both", length=5)
ax1.grid(True)

# Plot Trading Volume
ax2.plot(months, trading_volume, "s-", color="#9467bd", label=trading_volume_label, linewidth=2)
ax2.set_ylim(trading_volume_ylim)
ax2.set_xlim(months_xlim)
ax2.set_yticks(yticks_trading_volume)
ax2.set_xticks(months_xticks)
ax2.set_xlabel(months_xlabel)
ax2.set_ylabel(trading_volume_ylabel)
ax2.tick_params(axis="both", which="both", length=5)
ax2.grid(True)

# Create custom legend
green_dot = mlines.Line2D(
    [], [], color="#2ca02c", marker="o", markersize=8, label=legend_labels[0], linestyle="None"
)
purple_square = mlines.Line2D(
    [], [], color="#9467bd", marker="s", markersize=8, label=legend_labels[1], linestyle="None"
)
plt.legend(
    handles=[green_dot, purple_square],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_47.pdf", bbox_inches="tight")
