
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data representing population of different cities over years (in thousands)
years = np.array([2000, 2005, 2010, 2015, 2020])

city1_pop = np.array([500, 550, 600, 650, 700]) + np.random.normal(0, 10, 5)
city2_pop = np.array([300, 320, 350, 380, 400]) + np.random.normal(0, 10, 5)
city3_pop = np.array([200, 220, 250, 280, 310]) + np.random.normal(0, 10, 5)
city4_pop = np.array([400, 420, 450, 480, 500]) + np.random.normal(0, 10, 5)

# Extracted variables
fill_label_city1 = "City A"
fill_label_city2 = "City B"
fill_label_city3 = "City C"
fill_label_city4 = "City D"
title_text = "Population Growth Over Years"
xlabel_text = "Year"
ylabel_text = "Population (thousands)"
legend_title = "City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (150, 750)
xticks_values = years
yticks_values = np.arange(150, 751, 50)
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1

# Create the plot with an improved visualization style
plt.figure(figsize=(10, 7))
plt.fill_between(years, city1_pop, color="#2E8B57", alpha=0.7, label=fill_label_city1)
plt.fill_between(years, city2_pop, color="#4682B4", alpha=0.7, label=fill_label_city2)
plt.fill_between(years, city3_pop, color="#8A2BE2", alpha=0.7, label=fill_label_city3)
plt.fill_between(years, city4_pop, color="#FF6347", alpha=0.7, label=fill_label_city4)

# Add a title and labels
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_48.pdf", bbox_inches="tight")
