
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot with different geographical metrics
months = np.array([1, 2, 3, 4, 5, 6])
avg_elevation = np.array([250, 275, 260, 285, 300, 310]) + np.random.uniform(-10, 10, 6)
pop_density = np.array([100, 105, 102, 108, 110, 115]) + np.random.uniform(-5, 5, 6)
rainfall = np.array([50, 55, 48, 60, 58, 62]) + np.random.uniform(-7, 7, 6)
temperature_variation = np.array([20, 22, 21, 23, 25, 27]) + np.random.uniform(-2, 2, 6)
benchmark_geography = np.linspace(200, 200, len(months))  # Benchmark line

# Extracted variables for labels
fill_label_avg_elevation = "Avg Elevation (m)"
fill_label_pop_density = "Population Density (people/km²)"
fill_label_rainfall = "Rainfall (mm)"
fill_label_temperature_variation = "Temp Variation (°C)"
plot_label_benchmark = "Benchmark"
title_text = "Geographical Metrics Over 6 Months"
xlabel_text = "Months"
ylabel_text = "Measurements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 6)
ylim_values = (40, 320)
xticks_values = months
yticks_values = [50, 100, 150, 200, 250, 300]
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.08)
legend_ncol = 5

# Create the plot with a geographical style
plt.figure(figsize=(10, 6))
plt.fill_between(
    months, avg_elevation, color="#2a9d8f", alpha=0.3, label=fill_label_avg_elevation
)
plt.fill_between(
    months, pop_density, color="#e9c46a", alpha=0.3, label=fill_label_pop_density
)
plt.fill_between(
    months, rainfall, color="#264653", alpha=0.3, label=fill_label_rainfall
)
plt.fill_between(
    months, temperature_variation, color="#f4a261", alpha=0.3, label=fill_label_temperature_variation
)
plt.plot(
    months,
    benchmark_geography,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Adding a legend with a title
plt.legend(
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_53.pdf", bbox_inches="tight")
