
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot representing Annual Hours Spent on Communication Activities
years = np.array([2017, 2018, 2019, 2020, 2021, 2022])
emails = np.array([120, 130, 135, 145, 150, 160]) + np.random.normal(0, 5, 6)  # Adding noise
meetings = np.array([80, 85, 90, 100, 105, 110]) + np.random.normal(0, 5, 6)
calls = np.array([60, 65, 70, 72, 75, 80]) + np.random.normal(0, 5, 6)
conferences = np.array([40, 45, 50, 55, 58, 60]) + np.random.normal(0, 5, 6)
benchmark = np.linspace(100, 100, len(years))  # Benchmark line

# Extracted variables
fill_label_emails = "Emails"
fill_label_meetings = "Meetings"
fill_label_calls = "Calls"
fill_label_conferences = "Virtual Conferences"
plot_label_benchmark = "Benchmark"
title_text = "Annual Hours Spent on Communication Activities"
xlabel_text = "Year"
ylabel_text = "Hours Spent"
legend_title = "Activities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (30, 170)
xticks_values = years
yticks_values = np.arange(30, 171, 20)
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1)
legend_ncol = 1

# Create the plot with a communication-appropriate color scheme
plt.figure(figsize=(10, 6))
plt.fill_between(years, emails, color="#1f78b4", alpha=0.3, label=fill_label_emails)  # Blue
plt.fill_between(years, meetings, color="#33a02c", alpha=0.3, label=fill_label_meetings)  # Green
plt.fill_between(years, calls, color="#e31a1c", alpha=0.3, label=fill_label_calls)  # Red
plt.fill_between(years, conferences, color="#ff7f00", alpha=0.3, label=fill_label_conferences)  # Orange
plt.plot(
    years,
    benchmark,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_54.pdf", bbox_inches="tight")
