
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot representing box office earnings in different genres
years = np.array([2017, 2018, 2019, 2020, 2021, 2022])
genre_action = np.array([300, 320, 340, 330, 350, 370]) + np.random.normal(
    0, 10, 6
)  # Adding noise
genre_comedy = np.array([250, 260, 270, 290, 310, 330]) + np.random.normal(0, 10, 6)
genre_drama = np.array([200, 210, 220, 230, 240, 250]) + np.random.normal(0, 10, 6)
genre_scifi = np.array([150, 160, 170, 180, 190, 200]) + np.random.normal(0, 10, 6)
benchmark = np.linspace(280, 280, len(years))  # Benchmark line

# Extracted variables
fill_label_genre_action = "Action"
fill_label_genre_comedy = "Comedy"
fill_label_genre_drama = "Drama"
fill_label_genre_scifi = "Sci-Fi"
plot_label_benchmark = "Industry Average"
title_text = "Box Office Earnings Over Time by Genre"
xlabel_text = "Year"
ylabel_text = "Earnings (in millions)"
legend_title = "Movie Genres"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (140, 380)
xticks_values = years
yticks_values = np.arange(140, 381, 20)
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1)
legend_ncol = 1
# Create the plot with an entertainment-appropriate color scheme
plt.figure(figsize=(10, 6))
plt.fill_between(years, genre_action, color="#FF6347", alpha=0.3, label=fill_label_genre_action)
plt.fill_between(years, genre_comedy, color="#4682B4", alpha=0.3, label=fill_label_genre_comedy)
plt.fill_between(years, genre_drama, color="#3CB371", alpha=0.3, label=fill_label_genre_drama)
plt.fill_between(years, genre_scifi, color="#FFA500", alpha=0.3, label=fill_label_genre_scifi)
plt.plot(
    years,
    benchmark,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.1)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_56.pdf", bbox_inches="tight")
