
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Transportation Efficiency
augmentation_levels = ["0", "0.125", "0.25", "0.5", "1", "2", "4", "8"]
fuel_efficiency = np.array([3, 3.4, 3.7, 4, 4.5, 5, 5.5, 6])
average_travel_time = np.array([2, 1.8, 1.6, 1.5, 1.4, 1.3, 1.2, 1])
customer_satisfaction = np.array([1, 1.2, 1.5, 1.8, 2.1, 2.5, 2.8, 3])

# Calculate cumulative values for the stacked area chart
cumulative_fuel_efficiency = fuel_efficiency
cumulative_travel_time = cumulative_fuel_efficiency + average_travel_time
cumulative_customer_satisfaction = cumulative_travel_time + customer_satisfaction

# Positions for the bars on the x-axis
ind = np.arange(len(augmentation_levels))

# Variables for plot configuration
fuel_efficiency_label = "Fuel Efficiency"
average_travel_time_label = "Average Travel Time"
customer_satisfaction_label = "Customer Satisfaction"
xlabel_text = "Augmentation Level"
ylabel_text = "Performance Metrics"
title_text = "Cumulative Performance Metrics by Augmentation Level in Transportation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 7)
ylim_values = (0, 15)
yticks_values = np.arange(0, 16, 1)
legend_location = "upper left"
legend_fontsize = 12
legend_frameon = False
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 1
legend_bbox_to_anchor = (1.05, 1)

# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

ax.fill_between(
    augmentation_levels,
    0,
    cumulative_fuel_efficiency,
    label=fuel_efficiency_label,
    color="#66c2a5",
    alpha=0.7,
)
ax.fill_between(
    augmentation_levels,
    cumulative_fuel_efficiency,
    cumulative_travel_time,
    label=average_travel_time_label,
    color="#fc8d62",
    alpha=0.7,
)
ax.fill_between(
    augmentation_levels,
    cumulative_travel_time,
    cumulative_customer_satisfaction,
    label=customer_satisfaction_label,
    color="#8da0cb",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)

# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)
ax.tick_params(axis="both", which="both", color="gray")

# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_61.pdf", bbox_inches="tight")
