
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Time Periods
time_periods = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug"]

# Air Quality Data (random example data)
pm25_levels = np.array([35, 30, 28, 25, 40, 45, 42, 38])
ozone_levels = np.array([20, 22, 19, 24, 30, 35, 33, 28])
no2_levels = np.array([15, 18, 21, 19, 25, 28, 30, 29])

# Calculate cumulative values for stacked area chart
cumulative_pm25 = pm25_levels
cumulative_ozone = cumulative_pm25 + ozone_levels
cumulative_no2 = cumulative_ozone + no2_levels

# Positions for the bars on the x-axis
ind = np.arange(len(time_periods))

# Variables for plot configuration
pm25_label = "PM2.5 Levels"
ozone_label = "Ozone Concentration"
no2_label = "NO2 Concentration"
xlabel_text = "Months"
ylabel_text = "Air Quality Metrics"
title_text = "Cumulative Air Quality Metrics Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 7)
ylim_values = (0, 150)
yticks_values = np.arange(0, 151, 10)
legend_location = "upper left"
legend_fontsize = 12
legend_frameon = False
legend_shadow = True
legend_facecolor = "#ffffff"
legend_ncol = 1
legend_bbox_to_anchor = (1.05, 1)

# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

ax.fill_between(
    time_periods,
    0,
    cumulative_pm25,
    label=pm25_label,
    color="#66c2a5",
    alpha=0.7,
)
ax.fill_between(
    time_periods,
    cumulative_pm25,
    cumulative_ozone,
    label=ozone_label,
    color="#fc8d62",
    alpha=0.7,
)
ax.fill_between(
    time_periods,
    cumulative_ozone,
    cumulative_no2,
    label=no2_label,
    color="#8da0cb",
    alpha=0.7,
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)

# Labels, Title, and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)
ax.tick_params(axis="both", which="both", color="gray")

# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_62.pdf", bbox_inches="tight")
