
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Ensuring reproducibility
months = [
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
]
data_downloaded = np.array([50, 60, 70, 65, 90, 85, 120, 130, 110, 95, 100, 105])
data_uploaded = np.array([20, 25, 30, 35, 40, 35, 50, 55, 45, 40, 42, 39])

# Calculate cumulative values for stacked area chart
cumulative_downloaded = data_downloaded
cumulative_uploaded = cumulative_downloaded + data_uploaded

# Positions for the bars on the x-axis
ind = np.arange(len(months))

# Variables for plot configuration
downloaded_label = "Data Downloaded (GB)"
uploaded_label = "Data Uploaded (GB)"
xlabel_text = "Month"
ylabel_text = "Data Usage (GB)"
title_text = "Monthly Internet Data Usage Summary"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (0, 11)
ylim_values = (0, 400)
yticks_values = list(range(0, 450, 50))
legend_location = "upper left"
legend_fontsize = 10
legend_frameon = True
legend_shadow = False
legend_facecolor = "#f4f4f4"
legend_ncol = 2
legend_bbox_to_anchor = (0.1, 1.0)

# Plot
fig, ax = plt.subplots(figsize=(12, 8))  # Adjusted for better aspect ratio
ax.fill_between(
    months, 0, cumulative_downloaded, label=downloaded_label, color="#1f77b4", alpha=0.7
)
ax.fill_between(
    months, cumulative_downloaded, cumulative_uploaded, label=uploaded_label, color="#ff7f0e", alpha=0.7
)

# Enhancing the plot with additional visuals
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.set_yticks(yticks_values)
# Setting the x-axis and y-axis limits dynamically
ax.set_ylim(*ylim_values)  # Ensure all data fits well
ax.set_xlim(*xlim_values)
# Labels, Title and Grid
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=18, y=1.02)
ax.tick_params(axis="both", which="both", color="gray")
# Custom legend
ax.legend(
    loc=legend_location,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
    shadow=legend_shadow,
    facecolor=legend_facecolor,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_63.pdf", bbox_inches="tight")
