
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Set the seed for reproducibility
import numpy as np

np.random.seed(2)

# Data
years = np.arange(2010, 2020)
football_popularity = np.random.uniform(low=40, high=90, size=len(years))
basketball_popularity = np.random.uniform(low=30, high=80, size=len(years))
baseball_popularity = np.random.uniform(low=20, high=70, size=len(years))

# Variables for plot configuration
football_label = "Football Popularity"
basketball_label = "Basketball Popularity"
baseball_label = "Baseball Popularity"
xlabel_text = "Years"
ylabel_text = "Popularity Metrics"
title_text = "Sports Popularity Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_values = (0, 250)
xticks_values = years
yticks_values = [0, 50, 100, 150, 200, 250]
legend_location = "upper left"
legend_fontsize = 12

# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

# Stack the data
stack_data = np.vstack((football_popularity, basketball_popularity, baseball_popularity))

# Colors for each stack
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Area plot
ax.stackplot(
    years,
    stack_data,
    labels=[football_label, basketball_label, baseball_label],
    colors=colors,
    alpha=0.8,
)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Setting the x-axis and y-axis limits and ticks
ax.set_ylim(*ylim_values)
ax.set_xticks(xticks_values)
ax.set_yticks(yticks_values)

# Adding labels and title
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)

# Custom legend
ax.legend(loc=legend_location, fontsize=legend_fontsize, frameon=False)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_66.pdf", bbox_inches="tight")
