
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Set the seed for reproducibility
import numpy as np

np.random.seed(1)

# Data
years = np.arange(2010, 2020)
crop_yield = np.random.uniform(low=2, high=5, size=len(years))  # tons per hectare
rainfall = np.random.uniform(low=700, high=1200, size=len(years))  # mm
fertilizer_use = np.random.uniform(low=150, high=300, size=len(years))  # kg/ha

# Variables for plot configuration
crop_label = "Crop Yield (tons/ha)"
rainfall_label = "Rainfall (mm)"
fertilizer_label = "Fertilizer Use (kg/ha)"
xlabel_text = "Years"
ylabel_text = "Agricultural Metrics"
title_text = "Agricultural Trends Over Years"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim_values = (0, 1500)
xticks_values = years
yticks_values = np.arange(0, 1600, 200)
legend_location = "upper left"
legend_fontsize = 12
# Plot
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better aspect ratio

# Stack the data
stack_data = np.vstack((crop_yield, rainfall, fertilizer_use))

# Colors for each stack
colors = ["#8B4513", "#4682B4", "#32CD32"]

# Area plot
ax.stackplot(
    years,
    stack_data,
    labels=[crop_label, rainfall_label, fertilizer_label],
    colors=colors,
    alpha=0.7,
)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Setting the x-axis and y-axis limits and ticks
ax.set_ylim(*ylim_values)
ax.set_xticks(xticks_values)
ax.set_yticks(yticks_values)

# Adding labels and title
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
ax.set_title(title_text, fontsize=16, y=1.05)

# Custom legend
ax.legend(loc=legend_location, fontsize=legend_fontsize, frameon=False)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, which="both")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("area_67.pdf", bbox_inches="tight")

