
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Years for the x-axis
year = [2000, 2005, 2010, 2015, 2020, 2025, 2030, 2035]

# Media consumption data (in billions of hours)
media_consumption = {
    "Television": [2.5, 2.7, 2.9, 3.0, 3.1, 3.2, 3.3, 3.4],
    "Internet": [0.5, 0.9, 1.3, 1.7, 2.2, 2.8, 3.5, 4.2],
    "Radio": [1.2, 1.3, 1.4, 1.4, 1.5, 1.5, 1.6, 1.6],
    "Newspapers": [1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3],
    "Magazines": [0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1]
}

# Extracted variables
legend_labels = list(media_consumption.keys())
xlabel_value = "Year"
ylabel_value = "Consumption (Billions of Hours)"
title_value = "Growth of Media Consumption Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (2000, 2035)
ylim_values = (0, 15)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = False
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FF66B2"]

fig, ax = plt.subplots(figsize=(10, 7))
ax.stackplot(
    year,
    media_consumption.values(),
    labels=legend_labels,
    alpha=0.8,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)
ax.grid(True, linestyle='--', alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_72.pdf", bbox_inches="tight")
