
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
year = [2000, 2005, 2010, 2015, 2020, 2025, 2030, 2035]
media_consumption = {
    "Television": [2.5, 2.4, 2.2, 2.0, 1.8, 1.5, 1.2, 0.9],
    "Radio": [1.8, 1.6, 1.3, 1.0, 0.8, 0.6, 0.4, 0.2],
    "Online Streaming": [0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0],
    "Podcasts": [0.1, 0.2, 0.5, 0.8, 1.2, 1.6, 2.0, 2.4],
    "Social Media": [0.3, 0.8, 1.4, 2.0, 2.6, 3.2, 3.8, 4.4]
}

# Extracted variables
legend_labels = list(media_consumption.keys())
xlabel_value = "Year"
ylabel_value = "Consumption (Hours per Day)"
title_value = "Media Consumption Trends Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (2000, 2035)
ylim_values = (0, 12)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = False
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#8EC0E4", "#FFDA79", "#76E394", "#FF8C94", "#BAE1FF"]

fig, ax = plt.subplots(figsize=(10, 7))
ax.stackplot(
    year,
    media_consumption.values(),
    labels=legend_labels,
    alpha=0.8,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_73.pdf", bbox_inches="tight")
