
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
year = [1990, 1995, 2000, 2005, 2010, 2015, 2020, 2025]
population_by_religion = {
    "Christianity": [1.7, 1.8, 1.9, 2.0, 2.2, 2.4, 2.6, 2.8],
    "Islam": [1.0, 1.1, 1.3, 1.5, 1.7, 1.9, 2.1, 2.3],
    "Hinduism": [0.7, 0.73, 0.75, 0.78, 0.8, 0.85, 0.9, 0.95],
    "Buddhism": [0.35, 0.37, 0.38, 0.4, 0.42, 0.43, 0.44, 0.45],
    "Other Religions": [0.3, 0.32, 0.34, 0.36, 0.38, 0.4, 0.42, 0.44],
}

# Extracted variables
legend_labels = list(population_by_religion.keys())
xlabel_value = "Year"
ylabel_value = "Adherents (Billions)"
title_value = "Global Religious Adherence Growth"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1990, 2025)
ylim_values = (0, 10)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1.1)
title_y_position = 1.05
colors = ["#92c7a3", "#66b2b2", "#ffcc99", "#ff9999", "#c2c2f0"]

fig, ax = plt.subplots(figsize=(10, 7))
ax.stackplot(
    year,
    population_by_religion.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_74.pdf", bbox_inches="tight")
